/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NonceManager;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.impl.AuthenticationInfoToken;
import io.undertow.security.impl.DigestAlgorithm;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.security.impl.DigestAuthorizationToken;
import io.undertow.security.impl.DigestQop;
import io.undertow.security.impl.DigestWWWAuthenticateToken;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DigestAuthenticationAuthTestCase
extends AuthenticationTestBase {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String REALM_NAME = "Digest_Realm";
    private static final String ZERO = "00000000";

    @Override
    protected AuthenticationMechanism getTestMechanism() {
        return new DigestAuthenticationMechanism(Collections.singletonList(DigestAlgorithm.MD5), Collections.singletonList(DigestQop.AUTH), REALM_NAME, "/", (NonceManager)new SimpleNonceManager(), true);
    }

    private String createNonce() {
        Random rand = new Random();
        byte[] nonceBytes = new byte[32];
        rand.nextBytes(nonceBytes);
        return HexConverter.convertToHexString((byte[])nonceBytes);
    }

    private String createResponse(String userName, String realm, String password, String method, String uri, String nonce, String nonceCount, String cnonce) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(userName.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(realm.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(password.getBytes(UTF_8));
        byte[] ha1 = HexConverter.convertToHexBytes((byte[])digest.digest());
        digest.update(method.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(uri.getBytes(UTF_8));
        byte[] ha2 = HexConverter.convertToHexBytes((byte[])digest.digest());
        digest.update(ha1);
        digest.update((byte)58);
        digest.update(nonce.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(nonceCount.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(cnonce.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(DigestQop.AUTH.getToken().getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(ha2);
        return HexConverter.convertToHexString((byte[])digest.digest());
    }

    private String createRspAuth(String userName, String realm, String password, String uri, String nonce, String nonceCount, String cnonce) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(userName.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(realm.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(password.getBytes(UTF_8));
        byte[] ha1 = HexConverter.convertToHexBytes((byte[])digest.digest());
        digest.update((byte)58);
        digest.update(uri.getBytes(UTF_8));
        byte[] ha2 = HexConverter.convertToHexBytes((byte[])digest.digest());
        digest.update(ha1);
        digest.update((byte)58);
        digest.update(nonce.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(nonceCount.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(cnonce.getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(DigestQop.AUTH.getToken().getBytes(UTF_8));
        digest.update((byte)58);
        digest.update(ha2);
        return HexConverter.convertToHexString((byte[])digest.digest());
    }

    private String createAuthorizationLine(String userName, String password, String method, String uri, String nonce, int nonceCount, String cnonce, String opaque) throws Exception {
        StringBuilder sb = new StringBuilder(Headers.DIGEST.toString());
        sb.append(" ");
        sb.append(DigestAuthorizationToken.USERNAME.getName()).append("=").append("\"userOne\"").append(",");
        sb.append(DigestAuthorizationToken.REALM.getName()).append("=\"").append(REALM_NAME).append("\",");
        sb.append(DigestAuthorizationToken.NONCE.getName()).append("=\"").append(nonce).append("\",");
        sb.append(DigestAuthorizationToken.DIGEST_URI.getName()).append("=\"/\",");
        String nonceCountHex = this.toHex(nonceCount);
        String response = this.createResponse(userName, REALM_NAME, password, method, uri, nonce, nonceCountHex, cnonce);
        sb.append(DigestAuthorizationToken.RESPONSE.getName()).append("=\"").append(response).append("\",");
        sb.append(DigestAuthorizationToken.ALGORITHM.getName()).append("=\"").append(DigestAlgorithm.MD5.getToken()).append("\",");
        sb.append(DigestAuthorizationToken.CNONCE.getName()).append("=\"").append(cnonce).append("\",");
        sb.append(DigestAuthorizationToken.OPAQUE.getName()).append("=\"").append(opaque).append("\",");
        sb.append(DigestAuthorizationToken.MESSAGE_QOP.getName()).append("=\"").append(DigestQop.AUTH.getToken()).append("\",");
        sb.append(DigestAuthorizationToken.NONCE_COUNT.getName()).append("=").append(nonceCountHex);
        return sb.toString();
    }

    private String toHex(int number) {
        String temp = Integer.toHexString(number);
        return ZERO.substring(temp.length()) + temp;
    }

    @Test
    public void testDigestSuccess() throws Exception {
        this.setAuthenticationChain();
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        Assert.assertEquals((Object)DigestQop.AUTH.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.MESSAGE_QOP));
        String clientNonce = this.createNonce();
        int nonceCount = 1;
        String nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        String opaque = (String)parsedHeader.get(DigestWWWAuthenticateToken.OPAQUE);
        Assert.assertNotNull((Object)opaque);
        for (int i = 0; i < 5; ++i) {
            client = new TestHttpClient();
            get = new HttpGet(DefaultServer.getDefaultServerURL());
            int thisNonceCount = nonceCount++;
            String authorization = this.createAuthorizationLine("userOne", "passwordOne", "GET", "/", nonce, thisNonceCount, clientNonce, opaque);
            get.addHeader(Headers.AUTHORIZATION.toString(), authorization);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            values = result.getHeaders("ProcessedBy");
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
            this.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
            values = result.getHeaders("Authentication-Info");
            Assert.assertEquals((long)1L, (long)values.length);
            Map parsedAuthInfo = AuthenticationInfoToken.parseHeader((String)values[0].getValue());
            Assert.assertEquals((String)"Didn't expect a new nonce.", (Object)nonce, parsedAuthInfo.get(AuthenticationInfoToken.NEXT_NONCE));
            Assert.assertEquals((Object)DigestQop.AUTH.getToken(), parsedAuthInfo.get(AuthenticationInfoToken.MESSAGE_QOP));
            String nonceCountString = this.toHex(thisNonceCount);
            Assert.assertEquals((Object)this.createRspAuth("userOne", REALM_NAME, "passwordOne", "/", nonce, nonceCountString, clientNonce), parsedAuthInfo.get(AuthenticationInfoToken.RESPONSE_AUTH));
            Assert.assertEquals((Object)clientNonce, parsedAuthInfo.get(AuthenticationInfoToken.CNONCE));
            Assert.assertEquals((Object)nonceCountString, parsedAuthInfo.get(AuthenticationInfoToken.NONCE_COUNT));
        }
    }

    @Test
    public void testBadUsername() throws Exception {
        this.setAuthenticationChain();
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        Assert.assertEquals((Object)DigestQop.AUTH.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.MESSAGE_QOP));
        String clientNonce = this.createNonce();
        int nonceCount = 1;
        String nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        String opaque = (String)parsedHeader.get(DigestWWWAuthenticateToken.OPAQUE);
        Assert.assertNotNull((Object)opaque);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        int thisNonceCount = nonceCount++;
        String authorization = this.createAuthorizationLine("noUser", "passwordOne", "GET", "/", nonce, thisNonceCount, clientNonce, opaque);
        get.addHeader(Headers.AUTHORIZATION.toString(), authorization);
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        this.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    @Test
    public void testBadPassword() throws Exception {
        this.setAuthenticationChain();
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        Assert.assertEquals((Object)DigestQop.AUTH.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.MESSAGE_QOP));
        String clientNonce = this.createNonce();
        int nonceCount = 1;
        String nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        String opaque = (String)parsedHeader.get(DigestWWWAuthenticateToken.OPAQUE);
        Assert.assertNotNull((Object)opaque);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        int thisNonceCount = nonceCount++;
        String authorization = this.createAuthorizationLine("userOne", "badPassword", "GET", "/", nonce, thisNonceCount, clientNonce, opaque);
        get.addHeader(Headers.AUTHORIZATION.toString(), authorization);
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        this.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    @Test
    public void testBadNonce() throws Exception {
        this.setAuthenticationChain();
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        Assert.assertEquals((Object)DigestQop.AUTH.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.MESSAGE_QOP));
        String clientNonce = this.createNonce();
        int nonceCount = 1;
        String nonce = "AU1aCIiy48ENMTM1MTE3OTUxMDU2OLrHnBlV2GBzzguCWOPET+0=";
        String opaque = (String)parsedHeader.get(DigestWWWAuthenticateToken.OPAQUE);
        Assert.assertNotNull((Object)opaque);
        client = new TestHttpClient();
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        int thisNonceCount = nonceCount++;
        String authorization = this.createAuthorizationLine("userOne", "badPassword", "GET", "/", nonce, thisNonceCount, clientNonce, opaque);
        get.addHeader(Headers.AUTHORIZATION.toString(), authorization);
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        this.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    @Test
    public void testNonceCountReUse() throws Exception {
        this.setAuthenticationChain();
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        String value = values[0].getValue();
        Assert.assertTrue((boolean)value.startsWith(Headers.DIGEST.toString()));
        Map parsedHeader = DigestWWWAuthenticateToken.parseHeader((String)value.substring(7));
        Assert.assertEquals((Object)REALM_NAME, parsedHeader.get(DigestWWWAuthenticateToken.REALM));
        Assert.assertEquals((Object)DigestAlgorithm.MD5.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.ALGORITHM));
        Assert.assertEquals((Object)DigestQop.AUTH.getToken(), parsedHeader.get(DigestWWWAuthenticateToken.MESSAGE_QOP));
        String clientNonce = this.createNonce();
        int nonceCount = 1;
        String nonce = (String)parsedHeader.get(DigestWWWAuthenticateToken.NONCE);
        String opaque = (String)parsedHeader.get(DigestWWWAuthenticateToken.OPAQUE);
        Assert.assertNotNull((Object)opaque);
        for (int i = 0; i < 2; ++i) {
            client = new TestHttpClient();
            get = new HttpGet(DefaultServer.getDefaultServerURL());
            int thisNonceCount = nonceCount;
            String authorization = this.createAuthorizationLine("userOne", "passwordOne", "GET", "/", nonce, thisNonceCount, clientNonce, opaque);
            get.addHeader(Headers.AUTHORIZATION.toString(), authorization);
            result = client.execute((HttpUriRequest)get);
            if (i == 0) {
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                this.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
                values = result.getHeaders("ProcessedBy");
                Assert.assertEquals((long)1L, (long)values.length);
                Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
                values = result.getHeaders("Authentication-Info");
                Assert.assertEquals((long)1L, (long)values.length);
                Map parsedAuthInfo = AuthenticationInfoToken.parseHeader((String)values[0].getValue());
                Assert.assertEquals((String)"Didn't expect a new nonce.", (Object)nonce, parsedAuthInfo.get(AuthenticationInfoToken.NEXT_NONCE));
                Assert.assertEquals((Object)DigestQop.AUTH.getToken(), parsedAuthInfo.get(AuthenticationInfoToken.MESSAGE_QOP));
                String nonceCountString = this.toHex(thisNonceCount);
                Assert.assertEquals((Object)this.createRspAuth("userOne", REALM_NAME, "passwordOne", "/", nonce, nonceCountString, clientNonce), parsedAuthInfo.get(AuthenticationInfoToken.RESPONSE_AUTH));
                Assert.assertEquals((Object)clientNonce, parsedAuthInfo.get(AuthenticationInfoToken.CNONCE));
                Assert.assertEquals((Object)nonceCountString, parsedAuthInfo.get(AuthenticationInfoToken.NONCE_COUNT));
                continue;
            }
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        }
    }
}

