/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ParseState;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.xnio.OptionMap;

public abstract class HttpRequestParser {
    private static final int UTF8_ACCEPT = 0;
    private static final byte[] TYPES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] STATES = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    public static final int ASCII_MAX = 127;
    private final int maxParameters;
    private final int maxHeaders;
    private final boolean allowEncodedSlash;
    private static final int START = 0;
    private static final int FIRST_COLON = 1;
    private static final int FIRST_SLASH = 2;
    private static final int SECOND_SLASH = 3;
    private static final int HOST_DONE = 4;
    private static final int NORMAL = 0;
    private static final int WHITESPACE = 1;
    private static final int BEGIN_LINE_END = 2;
    private static final int LINE_END = 3;
    private static final int AWAIT_DATA_END = 4;

    public HttpRequestParser(OptionMap options) {
        this.maxParameters = options.get(UndertowOptions.MAX_PARAMETERS, 1000);
        this.maxHeaders = options.get(UndertowOptions.MAX_HEADERS, 200);
        this.allowEncodedSlash = options.get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
    }

    public static final HttpRequestParser instance(OptionMap options) {
        try {
            Class<?> cls = HttpRequestParser.class.getClassLoader().loadClass(HttpRequestParser.class.getName() + "$$generated");
            Constructor<?> ctor = cls.getConstructor(OptionMap.class);
            return (HttpRequestParser)ctor.newInstance(options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handle(ByteBuffer buffer, ParseState currentState, HttpServerExchange builder) {
        if (currentState.state == 0) {
            this.handleHttpVerb(buffer, currentState, builder);
            this.handlePath(buffer, currentState, builder);
            this.handleHttpVersion(buffer, currentState, builder);
            this.handleAfterVersion(buffer, currentState, builder);
            while (currentState.state != 8 && buffer.hasRemaining()) {
                this.handleHeader(buffer, currentState, builder);
                if (currentState.state != 7) continue;
                this.handleHeaderValue(buffer, currentState, builder);
            }
            return;
        }
        if (currentState.state == 1) {
            this.handlePath(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 3) {
            this.handleQueryParameters(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 4) {
            this.handleHttpVersion(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 5) {
            this.handleAfterVersion(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        while (currentState.state != 8) {
            if (currentState.state == 6) {
                this.handleHeader(buffer, currentState, builder);
                if (!buffer.hasRemaining()) {
                    return;
                }
            }
            if (currentState.state != 7) continue;
            this.handleHeaderValue(buffer, currentState, builder);
            if (buffer.hasRemaining()) continue;
            return;
        }
    }

    abstract void handleHttpVerb(ByteBuffer var1, ParseState var2, HttpServerExchange var3);

    abstract void handleHttpVersion(ByteBuffer var1, ParseState var2, HttpServerExchange var3);

    abstract void handleHeader(ByteBuffer var1, ParseState var2, HttpServerExchange var3);

    /*
     * Enabled aggressive block sorting
     */
    final void handlePath(ByteBuffer buffer, ParseState state, HttpServerExchange exchange) {
        StringBuilder stringBuilder = state.stringBuilder;
        int parseState = state.parseState;
        int canonicalPathStart = state.pos;
        int urlDecodeState = state.urlDecodeState;
        int urlDecodeCurrentByte = (urlDecodeState & 0xFFFF00) >> 8;
        urlDecodeState &= 0xFF;
        int urlDecodeCodePoint = state.urlDecodeCodePoint;
        StringBuilder encodedStringBuilder = state.encodedStringBuilder;
        while (true) {
            char next;
            block36: {
                if (!buffer.hasRemaining()) {
                    state.parseState = parseState;
                    state.pos = canonicalPathStart;
                    state.urlDecodeState = urlDecodeState | urlDecodeCurrentByte << 8;
                    state.urlDecodeCodePoint = urlDecodeCodePoint;
                    state.encodedStringBuilder = encodedStringBuilder;
                    return;
                }
                next = (char)buffer.get();
                if (next == ' ' || next == '\t') {
                    if (stringBuilder.length() == 0) continue;
                    String path = stringBuilder.toString();
                    if (parseState < 4) {
                        exchange.setParsedRequestPath(false, encodedStringBuilder != null ? encodedStringBuilder.toString() : path, path);
                    } else {
                        exchange.setParsedRequestPath(true, encodedStringBuilder != null ? encodedStringBuilder.toString() : path, path.substring(canonicalPathStart));
                    }
                    exchange.setQueryString("");
                    state.state = 4;
                    state.stringBuilder.setLength(0);
                    state.parseState = 0;
                    state.pos = 0;
                    state.urlDecodeState = 0;
                    state.urlDecodeCodePoint = 0;
                    state.encodedStringBuilder = null;
                    return;
                }
                if (next == '\r' || next == '\n') {
                    throw UndertowMessages.MESSAGES.failedToParsePath();
                }
                if (next == '?' && (parseState == 0 || parseState == 4)) {
                    String path = stringBuilder.toString();
                    if (parseState < 4) {
                        exchange.setParsedRequestPath(false, encodedStringBuilder != null ? encodedStringBuilder.toString() : path, path);
                    } else {
                        exchange.setParsedRequestPath(true, encodedStringBuilder != null ? encodedStringBuilder.toString() : path, path.substring(canonicalPathStart));
                    }
                    state.state = 3;
                    state.stringBuilder.setLength(0);
                    state.parseState = 0;
                    state.pos = 0;
                    state.urlDecodeState = 0;
                    state.urlDecodeCodePoint = 0;
                    state.encodedStringBuilder = null;
                    this.handleQueryParameters(buffer, state, exchange);
                    return;
                }
                if (next == ';' && (parseState == 0 || parseState == 4)) {
                    String path = stringBuilder.toString();
                    if (parseState < 4) {
                        exchange.setParsedRequestPath(path);
                    } else {
                        exchange.setParsedRequestPath(path.substring(canonicalPathStart));
                    }
                    if (state.encodedStringBuilder == null) {
                        state.encodedStringBuilder = new StringBuilder(stringBuilder.toString());
                    }
                    state.encodedStringBuilder.append(';');
                    state.state = 2;
                    state.stringBuilder.setLength(0);
                    state.parseState = 0;
                    state.pos = 0;
                    state.urlDecodeState = 0;
                    state.urlDecodeCodePoint = 0;
                    this.handlePathParameters(buffer, state, exchange);
                    return;
                }
                if (encodedStringBuilder != null) {
                    encodedStringBuilder.append(next);
                }
                if (urlDecodeCurrentByte != 0) {
                    if (next >= '0' && next <= '9' || next >= 'a' && next <= 'f' || next >= 'A' && next <= 'F') {
                        if (urlDecodeCurrentByte == 65535) {
                            urlDecodeCurrentByte = Integer.parseInt("" + next, 16);
                            continue;
                        }
                        urlDecodeCurrentByte <<= 4;
                        byte type = TYPES[(urlDecodeCurrentByte += Integer.parseInt("" + next, 16)) & 0xFF];
                        urlDecodeCodePoint = urlDecodeState != 0 ? urlDecodeCurrentByte & 0x3F | urlDecodeCodePoint << 6 : 255 >> type & urlDecodeCurrentByte;
                        if ((urlDecodeState = STATES[urlDecodeState + type]) == 0) {
                            if (urlDecodeCodePoint > 127) {
                                for (char c : Character.toChars(urlDecodeCodePoint)) {
                                    stringBuilder.append(c);
                                }
                                urlDecodeCurrentByte = 0;
                                continue;
                            }
                            next = (char)urlDecodeCodePoint;
                            urlDecodeCurrentByte = 0;
                            if (next == '/' && !this.allowEncodedSlash) {
                                stringBuilder.append("%2F");
                                continue;
                            }
                            break block36;
                        } else {
                            urlDecodeCurrentByte = 65535;
                            continue;
                        }
                    }
                    if (next == 37) continue;
                    throw UndertowMessages.MESSAGES.failedToParsePath();
                }
                if (next == '%') {
                    if (encodedStringBuilder == null) {
                        encodedStringBuilder = new StringBuilder(stringBuilder.toString());
                        encodedStringBuilder.append(next);
                    }
                    urlDecodeCurrentByte = 65535;
                    urlDecodeCodePoint = 0;
                    urlDecodeState = 0;
                    continue;
                }
                if (next == '+') {
                    if (encodedStringBuilder == null) {
                        encodedStringBuilder = new StringBuilder(stringBuilder.toString());
                        encodedStringBuilder.append(next);
                    }
                    next = ' ';
                } else if (next == ':' && parseState == 0) {
                    parseState = 1;
                } else if (next == '/' && parseState == 1) {
                    parseState = 2;
                } else if (next == '/' && parseState == 2) {
                    parseState = 3;
                } else if (next == '/' && parseState == 3) {
                    parseState = 4;
                    canonicalPathStart = stringBuilder.length();
                } else if (parseState == 1 || parseState == 2) {
                    parseState = 0;
                }
            }
            stringBuilder.append(next);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void handleQueryParameters(ByteBuffer buffer, ParseState state, HttpServerExchange exchange) {
        StringBuilder stringBuilder = state.stringBuilder;
        StringBuilder encodedStringBuilder = state.encodedStringBuilder;
        int queryParamPos = state.pos;
        int mapCount = state.mapCount;
        int urlDecodeState = state.urlDecodeState;
        int urlDecodeCurrentByte = (urlDecodeState & 0xFFFF00) >> 8;
        urlDecodeState &= 0xFF;
        int urlDecodeCodePoint = state.urlDecodeCodePoint;
        String nextQueryParam = state.nextQueryParam;
        while (true) {
            char next;
            block26: {
                if (!buffer.hasRemaining()) {
                    state.pos = queryParamPos;
                    state.nextQueryParam = nextQueryParam;
                    state.urlDecodeState = urlDecodeState | urlDecodeCurrentByte << 8;
                    state.urlDecodeCodePoint = urlDecodeCodePoint;
                    state.mapCount = 0;
                    state.encodedStringBuilder = encodedStringBuilder;
                    return;
                }
                next = (char)buffer.get();
                if (next == ' ' || next == '\t') {
                    String queryString = encodedStringBuilder == null ? stringBuilder.toString() : encodedStringBuilder.toString();
                    exchange.setQueryString(queryString);
                    if (nextQueryParam == null) {
                        if (queryParamPos != stringBuilder.length()) {
                            exchange.addQueryParam(stringBuilder.substring(queryParamPos), "");
                        }
                    } else {
                        exchange.addQueryParam(nextQueryParam, stringBuilder.substring(queryParamPos));
                    }
                    state.state = 4;
                    state.stringBuilder.setLength(0);
                    state.pos = 0;
                    state.nextQueryParam = null;
                    state.urlDecodeCodePoint = 0;
                    state.urlDecodeState = 0;
                    state.mapCount = 0;
                    state.encodedStringBuilder = null;
                    return;
                }
                if (next == '\r' || next == '\n') {
                    throw UndertowMessages.MESSAGES.failedToParsePath();
                }
                if (encodedStringBuilder != null) {
                    encodedStringBuilder.append(next);
                }
                if (urlDecodeCurrentByte != 0) {
                    if (next >= '0' && next <= '9' || next >= 'a' && next <= 'f' || next >= 'A' && next <= 'F') {
                        if (urlDecodeCurrentByte == 65535) {
                            urlDecodeCurrentByte = Integer.parseInt("" + next, 16);
                            continue;
                        }
                        urlDecodeCurrentByte <<= 4;
                        byte type = TYPES[(urlDecodeCurrentByte += Integer.parseInt("" + next, 16)) & 0xFF];
                        urlDecodeCodePoint = urlDecodeState != 0 ? urlDecodeCurrentByte & 0x3F | urlDecodeCodePoint << 6 : 255 >> type & urlDecodeCurrentByte;
                        if ((urlDecodeState = STATES[urlDecodeState + type]) == 0) {
                            if (urlDecodeCodePoint > 127) {
                                for (char c : Character.toChars(urlDecodeCodePoint)) {
                                    stringBuilder.append(c);
                                }
                                urlDecodeCurrentByte = 0;
                                continue;
                            }
                            next = (char)urlDecodeCodePoint;
                            urlDecodeCurrentByte = 0;
                            break block26;
                        } else {
                            urlDecodeCurrentByte = 65535;
                            continue;
                        }
                    }
                    if (next == 37) continue;
                    throw UndertowMessages.MESSAGES.failedToParsePath();
                }
                if (next == '%') {
                    urlDecodeCurrentByte = 65535;
                    urlDecodeCodePoint = 0;
                    urlDecodeState = 0;
                    if (encodedStringBuilder != null) continue;
                    encodedStringBuilder = new StringBuilder(stringBuilder.toString());
                    encodedStringBuilder.append(next);
                    continue;
                }
                if (next == '+') {
                    if (encodedStringBuilder == null) {
                        encodedStringBuilder = new StringBuilder(stringBuilder.toString());
                        encodedStringBuilder.append(next);
                    }
                    next = ' ';
                } else if (next == '=' && nextQueryParam == null) {
                    nextQueryParam = stringBuilder.substring(queryParamPos);
                    queryParamPos = stringBuilder.length() + 1;
                } else if (next == '&' && nextQueryParam == null) {
                    if (mapCount++ > this.maxParameters) {
                        throw UndertowMessages.MESSAGES.tooManyQueryParameters(this.maxParameters);
                    }
                    exchange.addQueryParam(stringBuilder.substring(queryParamPos), "");
                    queryParamPos = stringBuilder.length() + 1;
                } else if (next == '&') {
                    if (mapCount++ > this.maxParameters) {
                        throw UndertowMessages.MESSAGES.tooManyQueryParameters(this.maxParameters);
                    }
                    exchange.addQueryParam(nextQueryParam, stringBuilder.substring(queryParamPos));
                    queryParamPos = stringBuilder.length() + 1;
                    nextQueryParam = null;
                }
            }
            stringBuilder.append(next);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void handlePathParameters(ByteBuffer buffer, ParseState state, HttpServerExchange exchange) {
        StringBuilder stringBuilder = state.stringBuilder;
        StringBuilder encodedStringBuilder = state.encodedStringBuilder;
        int queryParamPos = state.pos;
        int mapCount = state.mapCount;
        int urlDecodeState = state.urlDecodeState;
        int urlDecodeCurrentByte = (urlDecodeState & 0xFFFF00) >> 8;
        urlDecodeState &= 0xFF;
        int urlDecodeCodePoint = state.urlDecodeCodePoint;
        String nextQueryParam = state.nextQueryParam;
        while (true) {
            char next;
            block25: {
                if (!buffer.hasRemaining()) {
                    state.pos = queryParamPos;
                    state.nextQueryParam = nextQueryParam;
                    state.urlDecodeState = urlDecodeState | urlDecodeCurrentByte << 8;
                    state.urlDecodeCodePoint = urlDecodeCodePoint;
                    state.mapCount = 0;
                    state.encodedStringBuilder = encodedStringBuilder;
                    return;
                }
                next = (char)buffer.get();
                if (next == ' ' || next == '\t' || next == '?') {
                    if (nextQueryParam == null) {
                        if (queryParamPos != stringBuilder.length()) {
                            exchange.addPathParam(stringBuilder.substring(queryParamPos), "");
                        }
                    } else {
                        exchange.addPathParam(nextQueryParam, stringBuilder.substring(queryParamPos));
                    }
                    exchange.setParsedRequestPath(state.parseState > 4, encodedStringBuilder.toString());
                    state.state = 4;
                    state.stringBuilder.setLength(0);
                    state.pos = 0;
                    state.nextQueryParam = null;
                    state.urlDecodeCodePoint = 0;
                    state.urlDecodeState = 0;
                    state.mapCount = 0;
                    state.encodedStringBuilder = null;
                    if (next == '?') {
                        this.handleQueryParameters(buffer, state, exchange);
                    }
                    return;
                }
                if (next == '\r' || next == '\n') {
                    throw UndertowMessages.MESSAGES.failedToParsePath();
                }
                encodedStringBuilder.append(next);
                if (urlDecodeCurrentByte != 0) {
                    if (next >= '0' && next <= '9' || next >= 'a' && next <= 'f' || next >= 'A' && next <= 'F') {
                        if (urlDecodeCurrentByte == 65535) {
                            urlDecodeCurrentByte = Integer.parseInt("" + next, 16);
                            continue;
                        }
                        urlDecodeCurrentByte <<= 4;
                        byte type = TYPES[(urlDecodeCurrentByte += Integer.parseInt("" + next, 16)) & 0xFF];
                        urlDecodeCodePoint = urlDecodeState != 0 ? urlDecodeCurrentByte & 0x3F | urlDecodeCodePoint << 6 : 255 >> type & urlDecodeCurrentByte;
                        if ((urlDecodeState = STATES[urlDecodeState + type]) == 0) {
                            if (urlDecodeCodePoint > 127) {
                                for (char c : Character.toChars(urlDecodeCodePoint)) {
                                    stringBuilder.append(c);
                                }
                                urlDecodeCurrentByte = 0;
                                continue;
                            }
                            next = (char)urlDecodeCodePoint;
                            urlDecodeCurrentByte = 0;
                            break block25;
                        } else {
                            urlDecodeCurrentByte = 65535;
                            continue;
                        }
                    }
                    if (next == 37) continue;
                    throw UndertowMessages.MESSAGES.failedToParsePath();
                }
                if (next == '%') {
                    urlDecodeCurrentByte = 65535;
                    urlDecodeCodePoint = 0;
                    urlDecodeState = 0;
                    continue;
                }
                if (next == '+') {
                    next = ' ';
                } else if (next == '=' && nextQueryParam == null) {
                    nextQueryParam = stringBuilder.substring(queryParamPos);
                    queryParamPos = stringBuilder.length() + 1;
                } else if (next == '&' && nextQueryParam == null) {
                    if (mapCount++ > this.maxParameters) {
                        throw UndertowMessages.MESSAGES.tooManyQueryParameters(this.maxParameters);
                    }
                    exchange.addPathParam(stringBuilder.substring(queryParamPos), "");
                    queryParamPos = stringBuilder.length() + 1;
                } else if (next == '&') {
                    if (mapCount++ > this.maxParameters) {
                        throw UndertowMessages.MESSAGES.tooManyQueryParameters(this.maxParameters);
                    }
                    exchange.addPathParam(nextQueryParam, stringBuilder.substring(queryParamPos));
                    queryParamPos = stringBuilder.length() + 1;
                    nextQueryParam = null;
                }
            }
            stringBuilder.append(next);
        }
    }

    final void handleHeaderValue(ByteBuffer buffer, ParseState state, HttpServerExchange builder) {
        byte next;
        StringBuilder stringBuilder = state.stringBuilder;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            state.parseState = 0;
            if (state.mapCount++ > this.maxHeaders) {
                throw UndertowMessages.MESSAGES.tooManyHeaders(this.maxHeaders);
            }
        }
        int parseState = state.parseState;
        while (buffer.hasRemaining() && parseState == 0) {
            next = buffer.get();
            if (next == 13) {
                parseState = 2;
                continue;
            }
            if (next == 10) {
                parseState = 3;
                continue;
            }
            if (next == 32 || next == 9) {
                parseState = 1;
                continue;
            }
            stringBuilder.append((char)next);
        }
        while (buffer.hasRemaining()) {
            next = buffer.get();
            switch (parseState) {
                case 0: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) {
                        parseState = 1;
                        break;
                    }
                    stringBuilder.append((char)next);
                    break;
                }
                case 1: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) break;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append((char)next);
                    parseState = 0;
                    break;
                }
                case 2: 
                case 3: {
                    if (next == 10 && parseState == 2) {
                        parseState = 3;
                        break;
                    }
                    if (next == 9 || next == 32) {
                        parseState = 1;
                        break;
                    }
                    HttpString nextStandardHeader = state.nextHeader;
                    String headerValue = stringBuilder.toString();
                    builder.getRequestHeaders().add(nextStandardHeader, headerValue);
                    state.nextHeader = null;
                    state.leftOver = next;
                    state.stringBuilder.setLength(0);
                    if (next == 13) {
                        parseState = 4;
                        break;
                    }
                    state.state = 6;
                    state.parseState = 0;
                    return;
                }
                case 4: {
                    state.state = 8;
                    return;
                }
            }
        }
        state.parseState = parseState;
    }

    protected void handleAfterVersion(ByteBuffer buffer, ParseState state, HttpServerExchange builder) {
        boolean newLine;
        boolean bl = newLine = state.leftOver == 10;
        while (buffer.hasRemaining()) {
            byte next = buffer.get();
            if (newLine) {
                if (next == 10) {
                    state.state = 8;
                    return;
                }
                state.state = 6;
                state.leftOver = next;
                return;
            }
            if (next == 10) {
                newLine = true;
                continue;
            }
            if (next == 13 || next == 32 || next == 9) continue;
            state.state = 6;
            state.leftOver = next;
            return;
        }
        if (newLine) {
            state.leftOver = (byte)10;
        }
    }

    protected static Map<String, HttpString> httpStrings() {
        Class[] classs;
        HashMap<String, HttpString> results = new HashMap<String, HttpString>();
        for (Class c : classs = new Class[]{Headers.class, Methods.class, Protocols.class}) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.getType().equals(HttpString.class)) continue;
                field.setAccessible(true);
                HttpString result = null;
                try {
                    result = (HttpString)field.get(null);
                    results.put(result.toString(), result);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return results;
    }
}

