/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.server.handlers.resource.CachedResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.IOException;

public class CachingResourceManager
implements ResourceManager {
    private static final Object NO_RESOURCE = new Object();
    private final long maxFileSize;
    private final ResourceManager underlyingResourceManager;
    private final DirectBufferCache dataCache;
    private final LRUCache<String, Object> cache;

    public CachingResourceManager(int metadataCacheSize, long maxFileSize, DirectBufferCache dataCache, ResourceManager underlyingResourceManager, int metadataCacheMaxAge) {
        this.maxFileSize = maxFileSize;
        this.underlyingResourceManager = underlyingResourceManager;
        this.dataCache = dataCache;
        this.cache = new LRUCache(metadataCacheSize, metadataCacheMaxAge);
    }

    @Override
    public Resource getResource(String path) throws IOException {
        Object res = this.cache.get(path);
        if (res == NO_RESOURCE) {
            return null;
        }
        if (res != null) {
            return (Resource)res;
        }
        Resource underlying = this.underlyingResourceManager.getResource(path);
        if (underlying == null) {
            this.cache.add(path, NO_RESOURCE);
            return null;
        }
        CachedResource resource = new CachedResource(this, underlying, path);
        this.cache.add(path, resource);
        return resource;
    }

    DirectBufferCache getDataCache() {
        return this.dataCache;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }
}

