package io.undertow.predicate;

import io.undertow.server.HttpServerExchange;

/**
 * @author Stuart Douglas
 */
class SuffixMatchPredicate implements Predicate {

    private final String suffix;

    public SuffixMatchPredicate(final String suffix) {
            this.suffix = suffix;
    }

    @Override
    public boolean resolve(final HttpServerExchange value) {
        return value.getRelativePath().endsWith(suffix);
    }
}
