/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.channels.DelegatingStreamSinkChannel;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class IdleTimeoutStreamChannel<C extends StreamChannel>
extends DelegatingStreamSinkChannel<IdleTimeoutStreamChannel<C>>
implements StreamChannel {
    private final C channel;
    private final ChannelListener.SimpleSetter<C> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> closeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> writeSetter = new ChannelListener.SimpleSetter();
    private volatile XnioExecutor.Key handle;
    private static final AtomicReferenceFieldUpdater<IdleTimeoutStreamChannel, XnioExecutor.Key> KEY_UPDATER = AtomicReferenceFieldUpdater.newUpdater(IdleTimeoutStreamChannel.class, XnioExecutor.Key.class, "handle");
    private volatile long idleTimeout;
    private final Runnable timeoutCommand = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UndertowLogger.REQUEST_LOGGER.tracef("Timing out channel %s due to inactivity", new Object[0]);
            try {
                if (IdleTimeoutStreamChannel.this.channel.isWriteResumed()) {
                    ChannelListeners.invokeChannelListener((Channel)((Object)IdleTimeoutStreamChannel.this), (ChannelListener)IdleTimeoutStreamChannel.this.writeSetter.get());
                }
                if (IdleTimeoutStreamChannel.this.channel.isReadResumed()) {
                    ChannelListeners.invokeChannelListener((Channel)((Object)IdleTimeoutStreamChannel.this), (ChannelListener)IdleTimeoutStreamChannel.this.readSetter.get());
                }
            }
            finally {
                IoUtils.safeClose((Closeable)IdleTimeoutStreamChannel.this.channel);
            }
        }
    };

    public IdleTimeoutStreamChannel(C channel) {
        super((StreamSinkChannel)channel);
        channel.getReadSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.readSetter));
        channel.getCloseSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.closeSetter));
        this.channel = channel;
    }

    private void handleIdleTimeout(long ret) {
        long idleTimeout = this.idleTimeout;
        XnioExecutor.Key key = this.handle;
        if (idleTimeout > 0L) {
            if (ret == 0L && key == null) {
                XnioExecutor.Key k = this.channel.getWriteThread().executeAfter(this.timeoutCommand, idleTimeout, TimeUnit.MILLISECONDS);
                if (!KEY_UPDATER.compareAndSet(this, null, k)) {
                    k.remove();
                } else {
                    this.handle = k;
                }
            } else if (ret > 0L && key != null) {
                key.remove();
            }
        }
    }

    public ChannelListener.Setter<? extends StreamChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int w = this.channel.write(src);
        this.handleIdleTimeout(w);
        return w;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long w = this.channel.write(srcs, offset, length);
        this.handleIdleTimeout(w);
        return w;
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long w = this.channel.transferTo(position, count, target);
        this.handleIdleTimeout(w);
        return w;
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long w = this.channel.transferTo(count, throughBuffer, target);
        this.handleIdleTimeout(w);
        return w;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long r = this.channel.read(dsts, offset, length);
        this.handleIdleTimeout(r);
        return r;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        long r = this.channel.read(dsts);
        this.handleIdleTimeout(r);
        return r;
    }

    public int read(ByteBuffer dst) throws IOException {
        int r = this.channel.read(dst);
        this.handleIdleTimeout(r);
        return r;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        long r = this.channel.transferFrom(src, position, count);
        this.handleIdleTimeout(r);
        return r;
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long r = this.channel.transferFrom(source, count, throughBuffer);
        this.handleIdleTimeout(r);
        return r;
    }

    public void suspendReads() {
        this.channel.suspendReads();
    }

    public void resumeReads() {
        this.channel.resumeReads();
    }

    public boolean isReadResumed() {
        return this.channel.isReadResumed();
    }

    public void wakeupReads() {
        this.channel.wakeupReads();
    }

    public void shutdownReads() throws IOException {
        this.channel.shutdownReads();
    }

    public void awaitReadable() throws IOException {
        this.channel.awaitReadable();
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.channel.awaitReadable(time, timeUnit);
    }

    public XnioExecutor getReadThread() {
        return this.channel.getReadThread();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        if (option == UndertowOptions.IDLE_TIMEOUT) {
            return true;
        }
        return super.supportsOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        T ret = super.setOption(option, value);
        if (option == UndertowOptions.IDLE_TIMEOUT) {
            this.idleTimeout = (Long)value;
            XnioExecutor.Key key = this.handle;
            if (key != null) {
                key.remove();
            }
            if (this.idleTimeout > 0L) {
                XnioExecutor.Key k = this.getWriteThread().executeAfter(this.timeoutCommand, this.idleTimeout, TimeUnit.MILLISECONDS);
                if (!KEY_UPDATER.compareAndSet(this, null, k)) {
                    k.remove();
                } else {
                    this.handle = k;
                }
            }
        }
        return ret;
    }
}

