/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.conduits.PipelingBufferingStreamSinkConduit;
import io.undertow.io.IoCallback;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;

public class HttpContinue {
    public static final String CONTINUE = "100-continue";
    private static final ByteBuffer BUFFER = ByteBuffer.wrap("HTTP/1.1 100 Continue\r\nConnection: keep-alive\r\n\r\n".getBytes());

    public static boolean requiresContinueResponse(HttpServerExchange exchange) {
        if (!exchange.isHttp11()) {
            return false;
        }
        if (exchange.getConnection().getExtraBytes() != null) {
            return false;
        }
        HeaderValues expect = exchange.getRequestHeaders().get(Headers.EXPECT);
        if (expect != null) {
            for (String header : expect) {
                if (!header.toLowerCase().equals(CONTINUE)) continue;
                return true;
            }
        }
        return false;
    }

    public static void sendContinueResponse(final HttpServerExchange exchange, final IoCallback callback) {
        if (!exchange.isResponseChannelAvailable()) {
            throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
        }
        final PipelingBufferingStreamSinkConduit pipelingbuffer = exchange.getAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY);
        StreamConnection channel = exchange.getConnection().getChannel();
        ConduitStreamSinkChannel sinkChannel = channel.getSinkChannel();
        if (pipelingbuffer != null) {
            try {
                if (!pipelingbuffer.flushPipelinedData()) {
                    sinkChannel.setWriteListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                        public void handleEvent(StreamSinkChannel channel) {
                            try {
                                if (pipelingbuffer.flushPipelinedData()) {
                                    channel.suspendWrites();
                                    HttpContinue.internalSendContinueResponse(exchange, channel, callback);
                                }
                            }
                            catch (IOException e) {
                                callback.onException(exchange, null, e);
                                IoUtils.safeClose((Closeable)channel);
                                return;
                            }
                        }
                    });
                    sinkChannel.resumeWrites();
                }
            }
            catch (IOException e) {
                callback.onException(exchange, null, e);
                return;
            }
        }
        HttpContinue.internalSendContinueResponse(exchange, (StreamSinkChannel)sinkChannel, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendContinueResponse(HttpServerExchange exchange) throws IOException {
        if (!exchange.isResponseChannelAvailable()) {
            throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
        }
        PipelingBufferingStreamSinkConduit pipelingBuffer = exchange.getAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY);
        StreamConnection channel = exchange.getConnection().getChannel();
        if (pipelingBuffer != null && !pipelingBuffer.flushPipelinedData()) {
            channel.getSinkChannel().awaitWritable();
        }
        HttpServerConnection.ConduitState oldState = exchange.getConnection().resetChannel();
        try {
            ByteBuffer buf = BUFFER.duplicate();
            channel.getSinkChannel().write(buf);
            while (buf.hasRemaining()) {
                channel.getSinkChannel().awaitWritable();
                channel.getSinkChannel().write(buf);
            }
            while (!channel.getSinkChannel().flush()) {
                channel.getSinkChannel().awaitWritable();
            }
        }
        finally {
            exchange.getConnection().restoreChannel(oldState);
        }
    }

    public static void rejectExchange(HttpServerExchange exchange) {
        exchange.setResponseCode(417);
        exchange.endExchange();
    }

    private static void internalSendContinueResponse(final HttpServerExchange exchange, StreamSinkChannel channel, final IoCallback callback) {
        final HttpServerConnection.ConduitState oldState = exchange.getConnection().resetChannel();
        final ByteBuffer buf = BUFFER.duplicate();
        int res = 0;
        do {
            try {
                res = channel.write(buf);
                if (res != 0) continue;
                channel.getWriteSetter().set((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                    public void handleEvent(StreamSinkChannel channel) {
                        int res = 0;
                        do {
                            try {
                                res = channel.write(buf);
                                if (res == 0) {
                                    return;
                                }
                            }
                            catch (IOException e) {
                                callback.onException(exchange, null, e);
                                return;
                            }
                        } while (buf.hasRemaining());
                        channel.suspendWrites();
                        HttpContinue.flushChannel(exchange, channel, callback, oldState);
                    }
                });
                channel.resumeWrites();
            }
            catch (IOException e) {
                callback.onException(exchange, null, e);
                return;
            }
        } while (buf.hasRemaining());
        HttpContinue.flushChannel(exchange, channel, callback, oldState);
    }

    private static void flushChannel(final HttpServerExchange exchange, StreamSinkChannel channel, final IoCallback callback, final HttpServerConnection.ConduitState oldState) {
        try {
            if (!channel.flush()) {
                channel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                    public void handleEvent(StreamSinkChannel channel) {
                        exchange.getConnection().restoreChannel(oldState);
                        callback.onComplete(exchange, null);
                        channel.suspendWrites();
                    }
                }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkChannel>(){

                    public void handleException(StreamSinkChannel channel, IOException exception) {
                        exchange.getConnection().restoreChannel(oldState);
                        callback.onException(exchange, null, exception);
                        channel.suspendWrites();
                    }
                }));
                channel.resumeWrites();
            } else {
                exchange.getConnection().restoreChannel(oldState);
                callback.onComplete(exchange, null);
            }
        }
        catch (IOException e) {
            callback.onException(exchange, null, e);
            return;
        }
    }
}

