/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.UndertowOptions;
import io.undertow.websockets.api.BinaryFrameSender;
import io.undertow.websockets.api.CloseFrameSender;
import io.undertow.websockets.api.CloseReason;
import io.undertow.websockets.api.FragmentedBinaryFrameSender;
import io.undertow.websockets.api.FragmentedTextFrameSender;
import io.undertow.websockets.api.FrameHandler;
import io.undertow.websockets.api.PingFrameSender;
import io.undertow.websockets.api.PongFrameSender;
import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.api.TextFrameSender;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.impl.DefaultBinaryFrameSender;
import io.undertow.websockets.impl.DefaultCloseFrameSender;
import io.undertow.websockets.impl.DefaultFragmentedBinaryFrameSender;
import io.undertow.websockets.impl.DefaultFragmentedTextFrameSender;
import io.undertow.websockets.impl.DefaultPingFrameSender;
import io.undertow.websockets.impl.DefaultPongFrameSender;
import io.undertow.websockets.impl.DefaultTextFrameSender;
import io.undertow.websockets.impl.FrameHandlerExecutor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.Pool;

public final class WebSocketChannelSession
implements WebSocketSession {
    private final WebSocketChannel channel;
    private final String id;
    private volatile FrameHandler frameHandler;
    private static final AtomicReferenceFieldUpdater<WebSocketChannelSession, FrameHandler> FRAME_HANDLER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(WebSocketChannelSession.class, FrameHandler.class, "frameHandler");
    private final TextFrameSender textFrameSender;
    private final BinaryFrameSender binaryFrameSender;
    private final PingFrameSender pingFrameSender;
    private final PongFrameSender pongFrameSender;
    private final CloseFrameSender closeFrameSender;
    private volatile int asyncSendTimeout;
    private volatile long maxTextFrameSize;
    private volatile long maxBinaryFrameSize;
    private final Executor frameHandlerExecutor;
    boolean closeFrameSent;
    final boolean executeInIoThread;

    public WebSocketChannelSession(WebSocketChannel channel, String id, boolean executeInIoThread) {
        this.channel = channel;
        this.id = id;
        this.executeInIoThread = executeInIoThread;
        this.textFrameSender = new DefaultTextFrameSender(this);
        this.binaryFrameSender = new DefaultBinaryFrameSender(this);
        this.pingFrameSender = new DefaultPingFrameSender(this);
        this.pongFrameSender = new DefaultPongFrameSender(this);
        this.closeFrameSender = new DefaultCloseFrameSender(this);
        this.frameHandlerExecutor = new FrameHandlerExecutor(channel.getWorker());
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        try {
            this.channel.setOption(UndertowOptions.IDLE_TIMEOUT, idleTimeout);
        }
        catch (IOException e) {
            WebSocketLogger.REQUEST_LOGGER.setIdleTimeFailed(e);
        }
    }

    @Override
    public long getIdleTimeout() {
        try {
            return this.channel.getOption(UndertowOptions.IDLE_TIMEOUT);
        }
        catch (IOException e) {
            WebSocketLogger.REQUEST_LOGGER.getIdleTimeFailed(e);
            return 0L;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean setAttribute(String key, Object value) {
        return this.channel.setAttribute(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.channel.getAttribute(key);
    }

    @Override
    public boolean isSecure() {
        return this.channel.isSecure();
    }

    @Override
    public FrameHandler setFrameHandler(FrameHandler handler) {
        return FRAME_HANDLER_UPDATER.getAndSet(this, handler);
    }

    @Override
    public FrameHandler getFrameHandler() {
        return this.frameHandler;
    }

    @Override
    public void sendPing(ByteBuffer payload, SendCallback callback) {
        this.pingFrameSender.sendPing(payload, callback);
    }

    @Override
    public void sendPing(ByteBuffer[] payload, SendCallback callback) {
        this.pingFrameSender.sendPing(payload, callback);
    }

    @Override
    public void sendPing(ByteBuffer payload) throws IOException {
        this.pingFrameSender.sendPing(payload);
    }

    @Override
    public void sendPing(ByteBuffer[] payload) throws IOException {
        this.pingFrameSender.sendPing(payload);
    }

    @Override
    public void sendPong(ByteBuffer payload, SendCallback callback) {
        this.pongFrameSender.sendPong(payload, callback);
    }

    @Override
    public void sendPong(ByteBuffer[] payload, SendCallback callback) {
        this.pongFrameSender.sendPong(payload, callback);
    }

    @Override
    public void sendPong(ByteBuffer payload) throws IOException {
        this.pongFrameSender.sendPong(payload);
    }

    @Override
    public void sendPong(ByteBuffer[] payload) throws IOException {
        this.pongFrameSender.sendPong(payload);
    }

    @Override
    public FragmentedBinaryFrameSender sendFragmentedBinary() {
        return new DefaultFragmentedBinaryFrameSender(this);
    }

    @Override
    public FragmentedTextFrameSender sendFragmentedText() {
        return new DefaultFragmentedTextFrameSender(this);
    }

    @Override
    public void sendBinary(ByteBuffer[] payload, SendCallback callback) {
        this.binaryFrameSender.sendBinary(payload, callback);
    }

    @Override
    public void sendBinary(ByteBuffer payload) throws IOException {
        this.binaryFrameSender.sendBinary(payload);
    }

    @Override
    public void sendBinary(ByteBuffer[] payload) throws IOException {
        this.binaryFrameSender.sendBinary(payload);
    }

    @Override
    public void sendBinary(ByteBuffer payload, SendCallback callback) {
        this.binaryFrameSender.sendBinary(payload, callback);
    }

    @Override
    public void sendBinary(FileChannel payloadChannel, int offset, long length, SendCallback callback) {
        this.binaryFrameSender.sendBinary(payloadChannel, offset, length, callback);
    }

    @Override
    public OutputStream sendBinary(long payloadSize) throws IOException {
        return this.binaryFrameSender.sendBinary(payloadSize);
    }

    @Override
    public void sendText(CharSequence payload, SendCallback callback) {
        this.textFrameSender.sendText(payload, callback);
    }

    @Override
    public void sendText(CharSequence payload) throws IOException {
        this.textFrameSender.sendText(payload);
    }

    @Override
    public Writer sendText(long payloadSize) throws IOException {
        return this.textFrameSender.sendText(payloadSize);
    }

    @Override
    public Set<String> getSubProtocols() {
        return this.channel.getSubProtocols();
    }

    @Override
    public void sendClose(CloseReason reason, SendCallback callback) {
        this.closeFrameSender.sendClose(reason, callback);
    }

    @Override
    public void sendClose(CloseReason reason) throws IOException {
        this.closeFrameSender.sendClose(reason);
    }

    public WebSocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public void setAsyncSendTimeout(int asyncSendTimeout) {
        this.asyncSendTimeout = asyncSendTimeout;
    }

    @Override
    public int getAsyncSendTimeout() {
        return this.asyncSendTimeout;
    }

    @Override
    public void setMaximumTextFrameSize(long size) {
        this.maxTextFrameSize = size;
    }

    @Override
    public long getMaximumTextFrameSize() {
        return this.maxTextFrameSize;
    }

    @Override
    public void setMaximumBinaryFrameSize(long size) {
        this.maxBinaryFrameSize = size;
    }

    @Override
    public long getMaximumBinaryFrameSize() {
        return this.maxBinaryFrameSize;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public boolean isCloseFrameReceived() {
        return this.channel.isCloseFrameReceived();
    }

    @Override
    public String getProtocolVersion() {
        return this.channel.getVersion().toHttpHeaderValue();
    }

    Executor getFrameHandlerExecutor() {
        return this.frameHandlerExecutor;
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.channel.getBufferPool();
    }
}

