/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpParser;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ParseState;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.nio.ByteBuffer;
import java.util.Deque;
import org.junit.Assert;
import org.junit.Test;

public class SimpleParserTestCase {
    @Test
    public void testSimpleRequest() {
        byte[] in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testCarriageReturnLineEnds() {
        byte[] in = "GET /somepath HTTP/1.1\rHost:   www.somehost.net\rOtherHeader: some\r    value\r\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testLineFeedsLineEnds() {
        byte[] in = "GET /somepath HTTP/1.1\nHost:   www.somehost.net\nOtherHeader: some\n    value\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testTabWhitespace() {
        byte[] in = "GET\t/somepath\tHTTP/1.1\nHost: \t www.somehost.net\nOtherHeader:\tsome\n \t  value\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testCanonicalPath() {
        byte[] in = "GET\thttp://www.somehost.net/somepath\tHTTP/1.1\nHost: \t www.somehost.net\nOtherHeader:\tsome\n \t  value\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null, null, null);
        HttpParser.INSTANCE.handle(ByteBuffer.wrap(in), in.length, context, result);
        Assert.assertEquals((Object)"/somepath", (Object)result.getRelativePath());
        Assert.assertEquals((Object)"http://www.somehost.net/somepath", (Object)result.getRequestURI());
    }

    @Test
    public void testNoHeaders() {
        byte[] in = "GET\t/aa\tHTTP/1.1\n\n\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null, null, null);
        HttpParser.INSTANCE.handle(ByteBuffer.wrap(in), in.length, context, result);
        Assert.assertTrue((boolean)context.isComplete());
        Assert.assertEquals((Object)"/aa", (Object)result.getRelativePath());
    }

    @Test
    public void testQueryParams() {
        byte[] in = "GET\thttp://www.somehost.net/somepath?a=b&b=c&d&e&f=\tHTTP/1.1\nHost: \t www.somehost.net\nOtherHeader:\tsome\n \t  value\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null, null, null);
        HttpParser.INSTANCE.handle(ByteBuffer.wrap(in), in.length, context, result);
        Assert.assertEquals((Object)"/somepath", (Object)result.getRelativePath());
        Assert.assertEquals((Object)"http://www.somehost.net/somepath", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"a=b&b=c&d&e&f=", (Object)result.getQueryString());
        Assert.assertEquals((Object)"b", ((Deque)result.getQueryParameters().get("a")).getFirst());
        Assert.assertEquals((Object)"c", ((Deque)result.getQueryParameters().get("b")).getFirst());
        Assert.assertEquals((Object)"", ((Deque)result.getQueryParameters().get("d")).getFirst());
        Assert.assertEquals((Object)"", ((Deque)result.getQueryParameters().get("e")).getFirst());
        Assert.assertEquals((Object)"", ((Deque)result.getQueryParameters().get("f")).getFirst());
    }

    @Test
    public void testSameHttpStringReturned() {
        byte[] in = "GET\thttp://www.somehost.net/somepath\tHTTP/1.1\nHost: \t www.somehost.net\nAccept-Charset:\tsome\n \t  value\n\r\n".getBytes();
        ParseState context1 = new ParseState();
        HttpServerExchange result1 = new HttpServerExchange(null, null, null);
        HttpParser.INSTANCE.handle(ByteBuffer.wrap(in), in.length, context1, result1);
        ParseState context2 = new ParseState();
        HttpServerExchange result2 = new HttpServerExchange(null, null, null);
        HttpParser.INSTANCE.handle(ByteBuffer.wrap(in), in.length, context2, result2);
        Assert.assertSame((Object)result1.getProtocol(), (Object)result2.getProtocol());
        Assert.assertSame((Object)result1.getRequestMethod(), (Object)result2.getRequestMethod());
        for (HttpString header : result1.getRequestHeaders().getHeaderNames()) {
            boolean found = false;
            for (HttpString header2 : result1.getRequestHeaders().getHeaderNames()) {
                if (header != header2) continue;
                found = true;
                break;
            }
            if (header.equals(Headers.HOST)) {
                Assert.assertSame((Object)Headers.HOST, (Object)header);
            }
            Assert.assertTrue((String)("Could not found header " + header), (boolean)found);
        }
    }

    private void runTest(byte[] in) {
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null, null, null);
        HttpParser.INSTANCE.handle(ByteBuffer.wrap(in), in.length, context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath", (Object)result.getRequestURI());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertEquals((long)2L, (long)result.getRequestHeaders().getHeaderNames().size());
        Assert.assertEquals((Object)"www.somehost.net", (Object)result.getRequestHeaders().getFirst(new HttpString("Host")));
        Assert.assertEquals((Object)"some value", (Object)result.getRequestHeaders().getFirst(new HttpString("OtherHeader")));
        Assert.assertEquals((long)6L, (long)context.state);
    }
}

