/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.idm.X509CertificateCredential;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.test.utils.DefaultServer;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import io.undertow.util.TestHttpClient;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.x500.X500Principal;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AuthenticationTestBase {
    protected static final IdentityManager identityManager;

    protected void setAuthenticationChain() {
        ResponseHandler responseHandler = new ResponseHandler();
        AuthenticationCallHandler callHandler = new AuthenticationCallHandler((HttpHandler)responseHandler);
        AuthenticationConstraintHandler constraintHandler = new AuthenticationConstraintHandler((HttpHandler)callHandler);
        AuthenticationMechanism authMech = this.getTestMechanism();
        AuthenticationMechanismsHandler methodsAddHandler = new AuthenticationMechanismsHandler((HttpHandler)constraintHandler, Collections.singletonList(authMech));
        SecurityInitialHandler initialHandler = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, identityManager, (HttpHandler)methodsAddHandler);
        DefaultServer.setRootHandler((HttpHandler)initialHandler);
    }

    protected abstract AuthenticationMechanism getTestMechanism();

    @Test
    public void testNoMechanisms() throws Exception {
        DefaultServer.setRootHandler(new ResponseHandler());
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
    }

    protected static String getAuthenticatedUser(HttpServerExchange exchange) {
        Account account;
        SecurityContext context = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        if (context != null && (account = context.getAuthenticatedAccount()) != null) {
            return account.getPrincipal().getName();
        }
        return null;
    }

    static {
        final HashSet<String> certUsers = new HashSet<String>();
        certUsers.add("CN=Test Client,OU=OU,O=Org,L=City,ST=State,C=GB");
        final HashMap<String, char[]> passwordUsers = new HashMap<String, char[]>(2);
        passwordUsers.put("userOne", "passwordOne".toCharArray());
        passwordUsers.put("userTwo", "passwordTwo".toCharArray());
        identityManager = new IdentityManager(){

            public Account verify(Account account) {
                return account;
            }

            public Account verify(String id, Credential credential) {
                Account account = this.getAccount(id);
                if (account != null && this.verifyCredential(account, credential)) {
                    return account;
                }
                return null;
            }

            public Account verify(Credential credential) {
                X500Principal p;
                if (credential instanceof X509CertificateCredential && certUsers.contains((p = ((X509CertificateCredential)credential).getCertificate().getSubjectX500Principal()).getName())) {
                    return new Account(){

                        public Principal getPrincipal() {
                            return p;
                        }

                        public boolean isUserInGroup(String group) {
                            return false;
                        }
                    };
                }
                return null;
            }

            private boolean verifyCredential(Account account, Credential credential) {
                if (credential instanceof PasswordCredential) {
                    char[] password = ((PasswordCredential)credential).getPassword();
                    char[] expectedPassword = (char[])passwordUsers.get(account.getPrincipal().getName());
                    return Arrays.equals(password, expectedPassword);
                }
                return false;
            }

            public char[] getPassword(Account account) {
                return (char[])passwordUsers.get(account.getPrincipal().getName());
            }

            public Account getAccount(final String id) {
                if (passwordUsers.containsKey(id)) {
                    return new Account(){
                        private final Principal principal = new Principal(){

                            @Override
                            public String getName() {
                                return id;
                            }
                        };

                        public Principal getPrincipal() {
                            return this.principal;
                        }

                        public boolean isUserInGroup(String group) {
                            return false;
                        }
                    };
                }
                return null;
            }

            public byte[] getHash(Account account) {
                return null;
            }
        };
    }

    protected static class ResponseHandler
    implements HttpHandler {
        static final HttpString PROCESSED_BY = new HttpString("ProcessedBy");
        static final HttpString AUTHENTICATED_USER = new HttpString("AuthenticatedUser");

        protected ResponseHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            HeaderMap responseHeader = exchange.getResponseHeaders();
            responseHeader.add(PROCESSED_BY, "ResponseHandler");
            String user = AuthenticationTestBase.getAuthenticatedUser(exchange);
            if (user != null) {
                responseHeader.add(AUTHENTICATED_USER, user);
            }
            exchange.endExchange();
        }
    }
}

