/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import junit.framework.Assert;
import org.junit.Test;

public class HeaderOrderTestCase {
    @Test
    public void testHeadersOrder() throws Exception {
        Field orderIntField = HttpString.class.getDeclaredField("orderInt");
        orderIntField.setAccessible(true);
        Field[] fields = Headers.class.getDeclaredFields();
        ArrayList<HttpString> headers = new ArrayList<HttpString>();
        for (Field field : fields) {
            HttpString header;
            Object value = field.get(null);
            if (!(value instanceof HttpString) || (Integer)orderIntField.get(header = (HttpString)value) == 0) continue;
            headers.add(header);
        }
        Collections.sort(headers, new Comparator<HttpString>(){

            @Override
            public int compare(HttpString o1, HttpString o2) {
                return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
            }
        });
        int val = 1;
        for (HttpString header : headers) {
            Assert.assertEquals((Object)val++, (Object)orderIntField.get(header));
        }
    }
}

