/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowLogger;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.IOException;
import java.util.Map;

public class FormAuthenticationMechanism
implements AuthenticationMechanism {
    public static final String LOCATION_COOKIE = "FORM_AUTH_ORIGINAL_URL";
    private final String name;
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;

    public FormAuthenticationMechanism(String name, String loginPage, String errorPage) {
        this.name = name;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
        this.postLocation = "/j_security_check";
    }

    public FormAuthenticationMechanism(String name, String loginPage, String errorPage, String postLocation) {
        this.name = name;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
        this.postLocation = postLocation;
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestURI().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            return this.runFormAuth(exchange, securityContext);
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome runFormAuth(HttpServerExchange exchange, SecurityContext securityContext) {
        FormDataParser parser = exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
        if (parser == null) {
            UndertowLogger.REQUEST_LOGGER.debug("Could not authenticate as no form parser is present");
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        try {
            FormData data = parser.parseBlocking();
            FormData.FormValue jUsername = data.getFirst("j_username");
            FormData.FormValue jPassword = data.getFirst("j_password");
            if (jUsername == null || jPassword == null) {
                UndertowLogger.REQUEST_LOGGER.debug("Could not authenticate as username or password was not present in the posted result");
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            String userName = jUsername.getValue();
            String password = jPassword.getValue();
            AuthenticationMechanism.AuthenticationMechanismOutcome outcome = null;
            PasswordCredential credential = new PasswordCredential(password.toCharArray());
            try {
                IdentityManager identityManager = securityContext.getIdentityManager();
                Account account = identityManager.verify(userName, credential);
                if (account != null) {
                    securityContext.authenticationComplete(account, this.name, true);
                    outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                }
                if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                    this.handleRedirectBack(exchange);
                }
                return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            catch (Throwable throwable) {
                if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
                    this.handleRedirectBack(exchange);
                }
                return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void handleRedirectBack(HttpServerExchange exchange) {
        Map<String, Cookie> cookies = CookieImpl.getRequestCookies(exchange);
        if (cookies != null && cookies.containsKey(LOCATION_COOKIE)) {
            final String location = cookies.get(LOCATION_COOKIE).getValue();
            exchange.addDefaultResponseListener(new DefaultResponseListener(){

                @Override
                public boolean handleDefaultResponse(HttpServerExchange exchange) {
                    FormAuthenticationMechanism.sendRedirect(exchange, location);
                    exchange.endExchange();
                    return true;
                }
            });
            CookieImpl cookie = new CookieImpl(LOCATION_COOKIE);
            cookie.setMaxAge(0);
            CookieImpl.addResponseCookie(exchange, cookie);
        }
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestURI().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            Integer code = this.servePage(exchange, this.errorPage);
            return new AuthenticationMechanism.ChallengeResult(true, code);
        }
        this.storeInitialLocation(exchange);
        Integer code = this.servePage(exchange, this.loginPage);
        return new AuthenticationMechanism.ChallengeResult(true, code);
    }

    protected void storeInitialLocation(HttpServerExchange exchange) {
        CookieImpl.addResponseCookie(exchange, new CookieImpl(LOCATION_COOKIE, exchange.getRequestURI()));
    }

    protected Integer servePage(HttpServerExchange exchange, String location) {
        FormAuthenticationMechanism.sendRedirect(exchange, location);
        return 307;
    }

    static void sendRedirect(HttpServerExchange exchange, String location) {
        String host = exchange.getRequestHeaders().getFirst(Headers.HOST);
        if (host == null) {
            host = exchange.getDestinationAddress().getAddress().getHostAddress();
        }
        String loc = exchange.getRequestScheme() + "://" + host + location;
        exchange.getResponseHeaders().put(Headers.LOCATION, loc);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

