/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.cache.ResponseCache;
import io.undertow.server.handlers.resource.DirectoryUtils;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.MimeMappings;
import java.io.IOException;
import java.util.Date;

public class ResourceHandler
implements HttpHandler {
    private volatile boolean directoryListingEnabled = false;
    private volatile MimeMappings mimeMappings = MimeMappings.DEFAULT;
    private volatile Predicate<HttpServerExchange> cachable = Predicates.truePredicate();
    private volatile Predicate<HttpServerExchange> allowed = Predicates.truePredicate();
    private volatile ResourceManager resourceManager;
    private volatile Integer cacheTime;
    private volatile long lastExpiryDate;
    private volatile String lastExpiryHeader;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRequestMethod().equals(Methods.GET) || exchange.getRequestMethod().equals(Methods.POST)) {
            this.serveResource(exchange, true);
        } else if (exchange.getRequestMethod().equals(Methods.HEAD)) {
            this.serveResource(exchange, false);
        } else {
            exchange.setResponseCode(405);
            exchange.endExchange();
        }
    }

    private void serveResource(final HttpServerExchange exchange, final boolean sendContent) {
        if (DirectoryUtils.sendRequestedBlobs(exchange)) {
            return;
        }
        if (!this.allowed.resolve(exchange)) {
            exchange.setResponseCode(403);
            exchange.endExchange();
            return;
        }
        ResponseCache cache = exchange.getAttachment(ResponseCache.ATTACHMENT_KEY);
        boolean cachable = this.cachable.resolve(exchange);
        if (cachable && this.cacheTime != null) {
            exchange.getResponseHeaders().put(Headers.CACHE_CONTROL, "public, max-age=" + this.cacheTime);
            if (System.currentTimeMillis() > this.lastExpiryDate) {
                long date = System.currentTimeMillis();
                this.lastExpiryHeader = DateUtils.toDateString(new Date(date));
                this.lastExpiryDate = date;
            }
            exchange.getResponseHeaders().put(Headers.EXPIRES, this.lastExpiryHeader);
        }
        if (cache != null && cachable && cache.tryServeResponse()) {
            return;
        }
        exchange.dispatch(new Runnable(){

            @Override
            public void run() {
                Long contentLength;
                Resource resource = null;
                try {
                    resource = ResourceHandler.this.resourceManager.getResource(exchange.getRelativePath());
                }
                catch (IOException e) {
                    exchange.setResponseCode(500);
                    exchange.endExchange();
                    return;
                }
                if (resource == null) {
                    exchange.setResponseCode(404);
                    exchange.endExchange();
                    return;
                }
                if (resource.isDirectory()) {
                    DirectoryUtils.renderDirectoryListing(exchange, resource);
                    return;
                }
                ETag etag = resource.getETag();
                Date lastModified = resource.getLastModified();
                if (!ETagUtils.handleIfMatch(exchange, etag, false) || !DateUtils.handleIfUnmodifiedSince(exchange, lastModified)) {
                    exchange.setResponseCode(412);
                    exchange.endExchange();
                    return;
                }
                if (!ETagUtils.handleIfNoneMatch(exchange, etag, true) || !DateUtils.handleIfModifiedSince(exchange, lastModified)) {
                    exchange.setResponseCode(304);
                    exchange.endExchange();
                    return;
                }
                String contentType = resource.getContentType(ResourceHandler.this.mimeMappings);
                if (contentType != null) {
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
                } else {
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/octet-stream");
                }
                if (lastModified != null) {
                    exchange.getResponseHeaders().put(Headers.LAST_MODIFIED, DateUtils.toDateString(lastModified));
                }
                if (etag != null) {
                    exchange.getResponseHeaders().put(Headers.CONTENT_LANGUAGE, etag.toString());
                }
                if ((contentLength = resource.getContentLength()) != null) {
                    exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, contentLength.toString());
                }
                if (!sendContent) {
                    exchange.endExchange();
                } else {
                    resource.serve(exchange);
                }
            }
        });
    }

    public boolean isDirectoryListingEnabled() {
        return this.directoryListingEnabled;
    }

    public ResourceHandler setDirectoryListingEnabled(boolean directoryListingEnabled) {
        this.directoryListingEnabled = directoryListingEnabled;
        return this;
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    public ResourceHandler setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = mimeMappings;
        return this;
    }

    public Predicate<HttpServerExchange> getCachable() {
        return this.cachable;
    }

    public ResourceHandler setCachable(Predicate<HttpServerExchange> cachable) {
        this.cachable = cachable;
        return this;
    }

    public Predicate<HttpServerExchange> getAllowed() {
        return this.allowed;
    }

    public ResourceHandler setAllowed(Predicate<HttpServerExchange> allowed) {
        this.allowed = allowed;
        return this;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceHandler setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        return this;
    }

    public Integer getCacheTime() {
        return this.cacheTime;
    }

    public ResourceHandler setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
        return this;
    }
}

