/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.Deque;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SenderTestCase {
    public static final int SENDS = 10000;
    public static final String HELLO_WORLD = "Hello World";

    @BeforeClass
    public static void setup() {
        HttpHandler lotsOfSendsHandler = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                boolean blocking = ((Deque)exchange.getQueryParameters().get("blocking")).equals("true");
                if (blocking) {
                    exchange.startBlocking();
                }
                final Sender sender = exchange.getResponseSender();
                class SendClass
                implements Runnable,
                IoCallback {
                    int sent = 0;

                    SendClass() {
                    }

                    @Override
                    public void run() {
                        ++this.sent;
                        sender.send("a", (IoCallback)this);
                    }

                    public void onComplete(HttpServerExchange exchange, Sender sender2) {
                        if (this.sent++ == 10000) {
                            sender2.close();
                            return;
                        }
                        sender2.send("a", (IoCallback)this);
                    }

                    public void onException(HttpServerExchange exchange, Sender sender2, IOException exception) {
                        exception.printStackTrace();
                        exchange.endExchange();
                    }
                }
                new SendClass().run();
            }
        };
        HttpHandler fixedLengthSender = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(SenderTestCase.HELLO_WORLD);
            }
        };
        DefaultServer.setRootHandler((HttpHandler)new PathHandler().addPath("/lots", lotsOfSendsHandler).addPath("/fixed", fixedLengthSender));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncSender() throws IOException {
        StringBuilder sb = new StringBuilder(10000);
        for (int i = 0; i < 10000; ++i) {
            sb.append("a");
        }
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/lots?blocking=false");
        TestHttpClient client = new TestHttpClient();
        try {
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)sb.toString(), (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockingSender() throws IOException {
        StringBuilder sb = new StringBuilder(10000);
        for (int i = 0; i < 10000; ++i) {
            sb.append("a");
        }
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/lots?blocking=true");
        TestHttpClient client = new TestHttpClient();
        try {
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)sb.toString(), (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSenderSetsContentLength() throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/fixed");
        TestHttpClient client = new TestHttpClient();
        try {
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse(result));
            Header[] header = result.getHeaders("Content-Length");
            Assert.assertEquals((long)1L, (long)header.length);
            Assert.assertEquals((Object)("" + HELLO_WORLD.length()), (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

