/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version00;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.version00.WebSocket00Channel;
import io.undertow.websockets.core.protocol.version00.WebSocket00CloseFrameSourceChannel;
import io.undertow.websockets.utils.StreamSourceChannelAdapter;
import io.undertow.websockets.utils.TestUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class WebSocket00CloseFrameSourceChannelTest {
    @Test
    public void testReadWithByteBuffer() throws IOException {
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(new byte[]{1, 2})));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        WebSocket00CloseFrameSourceChannel channel = new WebSocket00CloseFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, mockChannel);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        Assert.assertEquals((long)-1L, (long)channel.read(buffer));
        Assert.assertEquals((String)"Nothing should be read", (long)buffer.capacity(), (long)buffer.remaining());
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel);
    }

    @Test
    public void testReadWithByteBuffers() throws IOException {
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(new byte[]{1, 2})));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        WebSocket00CloseFrameSourceChannel channel = new WebSocket00CloseFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, mockChannel);
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocate(8), ByteBuffer.allocate(8)};
        Assert.assertEquals((long)-1L, (long)channel.read(buffers));
        for (ByteBuffer buffer : buffers) {
            Assert.assertEquals((String)"Nothing should be read", (long)buffer.capacity(), (long)buffer.remaining());
        }
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel);
    }

    @Test
    public void testReadWithByteBuffersWithOffset() throws IOException {
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(new byte[]{1, 2})));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        WebSocket00CloseFrameSourceChannel channel = new WebSocket00CloseFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, mockChannel);
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocate(8), ByteBuffer.allocate(8)};
        Assert.assertEquals((long)-1L, (long)channel.read(buffers, 0, 1));
        for (ByteBuffer buffer : buffers) {
            Assert.assertEquals((String)"Nothing should be read", (long)buffer.capacity(), (long)buffer.remaining());
        }
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel);
    }

    @Test
    public void testTransferTo() throws IOException {
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(new byte[]{1, 2})));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        File file = File.createTempFile("undertow", ".tmp");
        file.deleteOnExit();
        WebSocket00CloseFrameSourceChannel channel = new WebSocket00CloseFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, mockChannel);
        Assert.assertEquals((long)-1L, (long)channel.transferTo(0L, 8L, new FileOutputStream(file).getChannel()));
        Assert.assertEquals((String)"Nothing should be read", (long)0L, (long)file.length());
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel);
    }

    @Test
    public void testTransferToWithBuffer() throws IOException {
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSinkChannel mockSink = (StreamSinkChannel)EasyMock.createMock(StreamSinkChannel.class);
        EasyMock.replay((Object[])new Object[]{mockSink});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(new byte[]{1, 2})));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        WebSocket00CloseFrameSourceChannel channel = new WebSocket00CloseFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, mockChannel);
        Assert.assertEquals((long)-1L, (long)channel.transferTo(1L, buffer, mockSink));
        Assert.assertEquals((String)"Nothing should be read", (long)buffer.capacity(), (long)buffer.remaining());
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel);
    }
}

