/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ConduitListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;

public class ChunkedStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final ConduitListener<? super ChunkedStreamSinkConduit> finishListener;
    private final int config;
    private static final byte[] LAST_CHUNK = "0\r\n\r\n".getBytes();
    public static final byte[] CRLF = "\r\n".getBytes();
    private int state;
    private int chunkleft = 0;
    private final ByteBuffer chunkingBuffer = ByteBuffer.allocate(14);
    private static final int CONF_FLAG_CONFIGURABLE = 1;
    private static final int CONF_FLAG_PASS_CLOSE = 2;
    private static final int FLAG_WRITES_SHUTDOWN = 1;
    private static final int FLAG_NEXT_SHUTDWON = 4;
    private static final int FLAG_WRITTEN_FIRST_CHUNK = 8;
    int written = 0;

    public ChunkedStreamSinkConduit(StreamSinkConduit next, boolean configurable, boolean passClose, ConduitListener<? super ChunkedStreamSinkConduit> finishListener) {
        super(next);
        this.finishListener = finishListener;
        this.config = (configurable ? 1 : 0) | (passClose ? 2 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        if (this.chunkleft == 0) {
            this.chunkingBuffer.clear();
            if (Bits.anyAreSet((int)this.state, (int)8)) {
                this.chunkingBuffer.put(CRLF);
            }
            this.written += src.remaining();
            this.chunkingBuffer.put(Integer.toHexString(src.remaining()).getBytes());
            this.chunkingBuffer.put(CRLF);
            this.chunkingBuffer.flip();
            this.state |= 8;
            int chunkingSize = this.chunkingBuffer.remaining();
            ByteBuffer[] buf = new ByteBuffer[]{this.chunkingBuffer, src};
            long result = ((StreamSinkConduit)this.next).write(buf, 0, buf.length);
            this.chunkleft = src.remaining();
            if (result < (long)chunkingSize) {
                return 0;
            }
            return (int)(result - (long)chunkingSize);
        }
        int oldLimit = src.limit();
        if (src.remaining() > this.chunkleft) {
            src.limit(this.chunkleft + src.position());
        }
        try {
            int chunkingSize = this.chunkingBuffer.remaining();
            if (chunkingSize > 0) {
                ByteBuffer[] buf = new ByteBuffer[]{this.chunkingBuffer, src};
                int origialRemaining = src.remaining();
                long result = ((StreamSinkConduit)this.next).write(buf, 0, buf.length);
                int srcWritten = origialRemaining - src.remaining();
                this.chunkleft -= srcWritten;
                if (result < (long)chunkingSize) {
                    int n = 0;
                    return n;
                }
                int n = (int)(result - (long)chunkingSize);
                return n;
            }
            int result = ((StreamSinkConduit)this.next).write(src);
            this.chunkleft -= result;
            int n = result;
            return n;
        }
        finally {
            src.limit(oldLimit);
        }
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!srcs[i].hasRemaining()) continue;
            return this.write(srcs[i]);
        }
        return 0L;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            if (Bits.anyAreSet((int)this.state, (int)4)) {
                return ((StreamSinkConduit)this.next).flush();
            }
            ((StreamSinkConduit)this.next).write(this.chunkingBuffer);
            if (!this.chunkingBuffer.hasRemaining()) {
                try {
                    if (Bits.anyAreSet((int)this.config, (int)2)) {
                        ((StreamSinkConduit)this.next).terminateWrites();
                    }
                    this.state |= 4;
                    boolean bl = ((StreamSinkConduit)this.next).flush();
                    return bl;
                }
                finally {
                    if (this.finishListener != null) {
                        this.finishListener.handleEvent(this);
                    }
                }
            }
            return false;
        }
        return ((StreamSinkConduit)this.next).flush();
    }

    public void terminateWrites() throws IOException {
        if (this.chunkleft != 0) {
            throw UndertowMessages.MESSAGES.chunkedChannelClosedMidChunk();
        }
        this.chunkingBuffer.clear();
        if (Bits.anyAreSet((int)this.state, (int)8)) {
            this.chunkingBuffer.put(CRLF);
        }
        this.chunkingBuffer.put(LAST_CHUNK);
        this.chunkingBuffer.flip();
        this.state |= 1;
    }

    public void awaitWritable() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        ((StreamSinkConduit)this.next).awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }
}

