/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;

public class AuthenticationCallHandler
implements HttpHandler {
    private final HttpHandler next;

    public AuthenticationCallHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        SecurityContext context = exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        if (context.authenticate()) {
            HttpHandlers.executeHandler(this.next, exchange);
        } else {
            exchange.endExchange();
        }
    }
}

