/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.MultipartParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.xnio.FileAccess;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;

public class MultiPartHandler
implements HttpHandler {
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private Executor executor;
    private File tempFileLocation = new File(System.getProperty("java.io.tmpdir"));
    private String defaultEncoding = "UTF-8";

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String mimeType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (mimeType != null && mimeType.startsWith(MULTIPART_FORM_DATA)) {
            String boundary = Headers.extractTokenFromHeader(mimeType, "boundary");
            MultiPartUploadHandler multiPartUploadHandler = new MultiPartUploadHandler(exchange, boundary, this.defaultEncoding);
            exchange.putAttachment(FormDataParser.ATTACHMENT_KEY, multiPartUploadHandler);
        }
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MultiPartHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public MultiPartHandler setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public File getTempFileLocation() {
        return this.tempFileLocation;
    }

    public MultiPartHandler setTempFileLocation(File tempFileLocation) {
        this.tempFileLocation = tempFileLocation;
        return this;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public MultiPartHandler setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    private final class MultiPartUploadHandler
    implements FormDataParser,
    Runnable,
    MultipartParser.PartHandler {
        private final HttpServerExchange exchange;
        private final FormData data = new FormData();
        private final String boundary;
        private final List<File> createdFiles = new ArrayList<File>();
        private String defaultEncoding;
        int currentType = 0;
        private final ByteArrayOutputStream contentBytes = new ByteArrayOutputStream();
        private String currentName;
        private String fileName;
        private File file;
        private FileChannel fileChannel;
        private HeaderMap headers;
        private HttpHandler handler;

        private MultiPartUploadHandler(HttpServerExchange exchange, String boundary, String defaultEncoding) {
            this.exchange = exchange;
            this.boundary = boundary;
            this.defaultEncoding = defaultEncoding;
        }

        @Override
        public void parse(HttpHandler handler) throws Exception {
            if (this.exchange.getAttachment(FORM_DATA) != null) {
                handler.handleRequest(this.exchange);
                return;
            }
            this.handler = handler;
            if (MultiPartHandler.this.executor == null) {
                this.exchange.dispatch(this);
            } else {
                this.exchange.dispatch(MultiPartHandler.this.executor, this);
            }
        }

        @Override
        public FormData parseBlocking() throws IOException {
            FormData existing = (FormData)this.exchange.getAttachment(FORM_DATA);
            if (existing != null) {
                return existing;
            }
            MultipartParser.ParseState parser = MultipartParser.beginParse(this.exchange.getConnection().getBufferPool(), this, this.boundary.getBytes());
            Pooled resource = this.exchange.getConnection().getBufferPool().allocate();
            StreamSourceChannel requestChannel = this.exchange.getRequestChannel();
            if (requestChannel == null) {
                throw new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided());
            }
            ByteBuffer buf = (ByteBuffer)resource.getResource();
            try {
                while (!parser.isComplete()) {
                    buf.clear();
                    requestChannel.awaitReadable();
                    int c = requestChannel.read(buf);
                    buf.flip();
                    if (c == -1) {
                        throw UndertowMessages.MESSAGES.connectionTerminatedReadingMultiPartData();
                    }
                    if (c == 0) continue;
                    parser.parse(buf);
                }
                this.exchange.putAttachment(FORM_DATA, this.data);
            }
            catch (MultipartParser.MalformedMessageException e) {
                throw new IOException(e);
            }
            finally {
                resource.free();
            }
            return (FormData)this.exchange.getAttachment(FORM_DATA);
        }

        @Override
        public void run() {
            try {
                this.parseBlocking();
                HttpHandlers.executeRootHandler(this.handler, this.exchange, false);
            }
            catch (Throwable e) {
                UndertowLogger.REQUEST_LOGGER.debug("Exception parsing data", e);
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
            }
        }

        @Override
        public void beginPart(HeaderMap headers) {
            this.headers = headers;
            String disposition = headers.getFirst(Headers.CONTENT_DISPOSITION);
            if (disposition != null && disposition.startsWith("form-data")) {
                this.currentName = Headers.extractQuotedValueFromHeader(disposition, "name");
                this.fileName = Headers.extractQuotedValueFromHeader(disposition, "filename");
                if (this.fileName != null) {
                    try {
                        this.file = File.createTempFile("undertow", "upload", MultiPartHandler.this.tempFileLocation);
                        this.createdFiles.add(this.file);
                        this.fileChannel = this.exchange.getConnection().getWorker().getXnio().openFile(this.file, FileAccess.READ_WRITE);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        @Override
        public void data(ByteBuffer buffer) {
            if (this.file == null) {
                while (buffer.hasRemaining()) {
                    this.contentBytes.write(buffer.get());
                }
            } else {
                try {
                    this.fileChannel.write(buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void endPart() {
            if (this.file != null) {
                this.data.add(this.currentName, this.file, this.fileName, this.headers);
                this.file = null;
                try {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String cs;
                String charset = this.defaultEncoding;
                String contentType = this.headers.getFirst(Headers.CONTENT_TYPE);
                if (contentType != null && (cs = Headers.extractTokenFromHeader(contentType, "charset")) != null) {
                    charset = cs;
                }
                this.data.add(this.currentName, new String(this.contentBytes.toByteArray(), charset), this.headers);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.contentBytes.reset();
        }

        public List<File> getCreatedFiles() {
            return this.createdFiles;
        }

        @Override
        public void close() throws IOException {
            this.exchange.dispatch(new Runnable(){

                @Override
                public void run() {
                    for (File file : MultiPartUploadHandler.this.getCreatedFiles()) {
                        if (!file.exists() || file.delete()) continue;
                        UndertowLogger.REQUEST_LOGGER.cannotRemoveUploadedFile(file);
                    }
                }
            });
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.defaultEncoding = encoding;
        }
    }
}

