/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Date;
import java.util.List;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class URLResource
implements Resource {
    private final URL url;
    private final URLConnection connection;

    public URLResource(URL url, URLConnection connection) {
        this.url = url;
        this.connection = connection;
    }

    @Override
    public Date getLastModified() {
        return new Date(this.connection.getLastModified());
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        int sepIndex;
        String path = this.url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 2);
        }
        if ((sepIndex = path.lastIndexOf("/")) != -1) {
            path = path.substring(sepIndex + 1);
        }
        return path;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public List<Resource> list() {
        return null;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.getName();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serve(HttpServerExchange exchange) {
        InputStream in = null;
        try {
            in = this.connection.getInputStream();
            StreamSinkChannel responseChannel = exchange.getResponseChannel();
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = in.read(buffer)) != -1) {
                Channels.writeBlocking((WritableByteChannel)responseChannel, (ByteBuffer)ByteBuffer.wrap(buffer, 0, read));
            }
        }
        catch (IOException e) {
            exchange.setResponseCode(500);
        }
        finally {
            IoUtils.safeClose((Closeable)in);
            exchange.endExchange();
        }
    }

    @Override
    public Long getContentLength() {
        return this.connection.getContentLength();
    }

    @Override
    public Resource getIndexResource(List<String> possible) {
        return null;
    }
}

