/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import java.util.Map;

public class SessionCookieConfig
implements SessionConfig {
    public static final String DEFAULT_SESSION_ID = "JSESSIONID";
    private String cookieName = "JSESSIONID";
    private String path = "/";
    private String domain;
    private boolean discard;
    private boolean secure;
    private boolean httpOnly;
    private int maxAge;
    private String comment;

    @Override
    public String rewriteUrl(String originalUrl, Session session) {
        return originalUrl;
    }

    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        Cookie cookie = new CookieImpl(this.cookieName, sessionId).setPath(this.path).setDomain(this.domain).setDiscard(this.discard).setSecure(this.secure).setHttpOnly(this.httpOnly).setComment(this.comment);
        if (this.maxAge > 0) {
            cookie.setMaxAge(this.maxAge);
        }
        CookieImpl.addResponseCookie(exchange, cookie);
    }

    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
        CookieImpl cookie = new CookieImpl(this.cookieName, sessionId).setPath(this.path).setDomain(this.domain).setDiscard(this.discard).setSecure(this.secure).setHttpOnly(this.httpOnly).setMaxAge(0);
        CookieImpl.addResponseCookie(exchange, cookie);
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        Cookie sessionId;
        Map<String, Cookie> cookies = CookieImpl.getRequestCookies(exchange);
        if (cookies != null && (sessionId = cookies.get(this.cookieName)) != null) {
            return sessionId.getValue();
        }
        return null;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public SessionCookieConfig setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public SessionCookieConfig setPath(String path) {
        this.path = path;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public SessionCookieConfig setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public SessionCookieConfig setDiscard(boolean discard) {
        this.discard = discard;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public SessionCookieConfig setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public SessionCookieConfig setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public SessionCookieConfig setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public SessionCookieConfig setComment(String comment) {
        this.comment = comment;
        return this;
    }
}

