/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.ajp.AjpParseState;
import io.undertow.ajp.AjpParser;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.xnio.IoUtils;

public class AjpParsingUnitTestCase {
    private static final ByteBuffer buffer;

    @Test
    public void testAjpParsing() {
        ByteBuffer buffer = AjpParsingUnitTestCase.buffer.duplicate();
        HttpServerExchange result = new HttpServerExchange(null, null, null);
        AjpParseState state = new AjpParseState();
        AjpParser.INSTANCE.parse(buffer, state, result);
        Assert.assertEquals((long)165L, (long)state.dataSize);
        Assert.assertTrue((boolean)state.isComplete());
        Assert.assertEquals((long)0L, (long)buffer.remaining());
        this.testResult(result);
    }

    @Test
    public void testByteByByteAjpParsing() {
        ByteBuffer buffer = AjpParsingUnitTestCase.buffer.duplicate();
        HttpServerExchange result = new HttpServerExchange(null, null, null);
        AjpParseState state = new AjpParseState();
        int limit = buffer.limit();
        for (int i = 1; i <= limit; ++i) {
            buffer.limit(i);
            AjpParser.INSTANCE.parse(buffer, state, result);
        }
        Assert.assertEquals((long)165L, (long)state.dataSize);
        Assert.assertTrue((boolean)state.isComplete());
        this.testResult(result);
    }

    private void testResult(HttpServerExchange exchange) {
        Assert.assertSame((Object)Methods.GET, (Object)exchange.getRequestMethod());
        Assert.assertEquals((Object)Protocols.HTTP_1_1, (Object)exchange.getProtocol());
        Assert.assertEquals((long)3L, (long)exchange.getRequestHeaders().getHeaderNames().size());
        Assert.assertEquals((Object)"localhost:7777", (Object)exchange.getRequestHeaders().getFirst(Headers.HOST));
        Assert.assertEquals((Object)"Apache-HttpClient/4.1.3 (java 1.5)", (Object)exchange.getRequestHeaders().getFirst(Headers.USER_AGENT));
        Assert.assertEquals((Object)"Keep-Alive", (Object)exchange.getRequestHeaders().getFirst(Headers.CONNECTION));
    }

    static {
        InputStream stream = AjpParsingUnitTestCase.class.getResourceAsStream("sample-ajp-request");
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int r = 0;
            byte[] buf = new byte[1024];
            while ((r = stream.read(buf)) > 0) {
                out.write(buf, 0, r);
            }
            buffer = ByteBuffer.wrap(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }
}

