/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.handlers;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.Headers;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FixedLengthResponseTestCase {
    private static final String MESSAGE = "My HTTP Request!";
    private static volatile String message;
    private static volatile HttpServerConnection connection;

    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (connection == null) {
                    connection = exchange.getConnection();
                } else if (!DefaultServer.isAjp() && connection.getChannel() != exchange.getConnection().getChannel()) {
                    Sender sender = exchange.getResponseSender();
                    sender.send("Connection not persistent", IoCallback.END_EXCHANGE);
                    return;
                }
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, message.length() + "");
                Sender sender = exchange.getResponseSender();
                sender.send(message, IoCallback.END_EXCHANGE);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendHttpRequest() throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        try {
            FixedLengthResponseTestCase.generateMessage(1);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
            FixedLengthResponseTestCase.generateMessage(1000);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static void generateMessage(int repetitions) {
        StringBuilder builder = new StringBuilder(repetitions * MESSAGE.length());
        for (int i = 0; i < repetitions; ++i) {
            builder.append(MESSAGE);
        }
        message = builder.toString();
    }
}

