/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.ajp.AjpReadListener;
import io.undertow.channels.ReadTimeoutStreamSourceChannel;
import io.undertow.channels.WriteTimeoutStreamSinkChannel;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.OpenListener;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class AjpOpenListener
implements OpenListener {
    private final Pool<ByteBuffer> bufferPool;
    private final int bufferSize;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;

    public AjpOpenListener(Pool<ByteBuffer> pool, int bufferSize) {
        this(pool, OptionMap.EMPTY, bufferSize);
    }

    public AjpOpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions, int bufferSize) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        this.bufferSize = bufferSize;
    }

    public void handleEvent(ConnectedStreamChannel channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", channel.getPeerAddress());
        }
        Object readChannel = channel;
        Object writeChannel = channel;
        if (channel.supportsOption(Options.READ_TIMEOUT)) {
            readChannel = new ReadTimeoutStreamSourceChannel((StreamSourceChannel)readChannel);
        }
        if (channel.supportsOption(Options.WRITE_TIMEOUT)) {
            writeChannel = new WriteTimeoutStreamSinkChannel((StreamSinkChannel)writeChannel);
        }
        Object assembledChannel = channel instanceof SslChannel ? new AssembledConnectedSslStreamChannel((SslChannel)channel, (StreamSourceChannel)readChannel, (StreamSinkChannel)writeChannel) : new AssembledConnectedStreamChannel((ConnectedChannel)channel, (StreamSourceChannel)readChannel, (StreamSinkChannel)writeChannel);
        HttpServerConnection connection = new HttpServerConnection((ConnectedStreamChannel)assembledChannel, this.bufferPool, this.rootHandler, this.undertowOptions, this.bufferSize);
        AjpReadListener readListener = new AjpReadListener((StreamSinkChannel)writeChannel, (StreamSourceChannel)readChannel, connection);
        readChannel.getReadSetter().set((ChannelListener)readListener);
        readListener.handleEvent((StreamSourceChannel)readChannel);
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
    }
}

