/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.UndertowLogger;
import io.undertow.ajp.AjpRequestConduit;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.StatusCodes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;

final class AjpResponseConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.channel.ajp.response");
    private static final int MAX_DATA_SIZE = 8186;
    private static final Map<HttpString, Integer> HEADER_MAP;
    private final Pool<ByteBuffer> pool;
    private volatile int state = 1;
    private static final AtomicIntegerFieldUpdater<AjpResponseConduit> stateUpdater;
    private Pooled<ByteBuffer> currentDataBuffer;
    private ByteBuffer[] packetHeaderAndDataBuffer;
    private final HttpServerExchange exchange;
    private volatile ByteBuffer readBodyChunkBuffer;
    private static final int FLAG_START = 1;
    private static final int FLAG_SHUTDOWN = 4;
    private static final int FLAG_DELEGATE_SHUTDOWN = 8;
    private static final int FLAG_CLOSE_QUEUED = 16;
    private static final int FLAG_WRITE_ENTERED = 32;

    AjpResponseConduit(StreamSinkConduit next, Pool<ByteBuffer> pool, HttpServerExchange exchange) {
        super(next);
        this.pool = pool;
        this.exchange = exchange;
        this.state = 1;
    }

    private void putInt(ByteBuffer buf, int value) {
        buf.put((byte)(value >> 8 & 0xFF));
        buf.put((byte)(value & 0xFF));
    }

    private void putString(ByteBuffer buf, String value) {
        int length = value.length();
        this.putInt(buf, length);
        for (int i = 0; i < length; ++i) {
            buf.put((byte)value.charAt(i));
        }
        buf.put((byte)0);
    }

    private boolean processWrite() throws IOException {
        int oldState;
        int writeEnteredState;
        do {
            if (((oldState = this.state) & 0x20) != 0) {
                return false;
            }
            if (!Bits.anyAreSet((int)this.state, (int)8)) continue;
            return true;
        } while (!stateUpdater.compareAndSet(this, this.state, writeEnteredState = oldState | 0x20));
        int newState = writeEnteredState;
        if (Bits.anyAreSet((int)oldState, (int)1)) {
            this.currentDataBuffer = this.pool.allocate();
            ByteBuffer buffer = (ByteBuffer)this.currentDataBuffer.getResource();
            this.packetHeaderAndDataBuffer = new ByteBuffer[1];
            this.packetHeaderAndDataBuffer[0] = buffer;
            buffer.put((byte)65);
            buffer.put((byte)66);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)4);
            this.putInt(buffer, this.exchange.getResponseCode());
            this.putString(buffer, StatusCodes.getReason(this.exchange.getResponseCode()));
            this.putInt(buffer, this.exchange.getResponseHeaders().getHeaderNames().size());
            for (HttpString header : this.exchange.getResponseHeaders()) {
                for (String headerValue : this.exchange.getResponseHeaders().get(header)) {
                    Integer headerCode = HEADER_MAP.get(header);
                    if (headerCode != null) {
                        this.putInt(buffer, headerCode);
                    } else {
                        this.putString(buffer, header.toString());
                    }
                    this.putString(buffer, headerValue);
                }
            }
            int dataLength = buffer.position() - 4;
            buffer.put(2, (byte)(dataLength >> 8 & 0xFF));
            buffer.put(3, (byte)(dataLength & 0xFF));
            buffer.flip();
            newState &= 0xFFFFFFFE;
        }
        if (this.currentDataBuffer != null && !this.writeCurrentBuffer()) {
            stateUpdater.set(this, newState & 0xFFFFFFDF);
            return false;
        }
        ByteBuffer readBuffer = this.readBodyChunkBuffer;
        if (readBuffer != null) {
            do {
                int res;
                if ((res = ((StreamSinkConduit)this.next).write(readBuffer)) != 0) continue;
                stateUpdater.set(this, newState & 0xFFFFFFDF);
                return false;
            } while (this.readBodyChunkBuffer.hasRemaining());
            this.readBodyChunkBuffer = null;
        }
        if (Bits.anyAreSet((int)this.state, (int)4) && Bits.allAreClear((int)this.state, (int)16)) {
            newState |= 0x10;
            this.currentDataBuffer = this.pool.allocate();
            ByteBuffer buffer = (ByteBuffer)this.currentDataBuffer.getResource();
            this.packetHeaderAndDataBuffer = new ByteBuffer[1];
            this.packetHeaderAndDataBuffer[0] = buffer;
            buffer.put((byte)65);
            buffer.put((byte)66);
            buffer.put((byte)0);
            buffer.put((byte)2);
            buffer.put((byte)5);
            buffer.put((byte)0);
            buffer.flip();
            if (!this.writeCurrentBuffer()) {
                stateUpdater.set(this, newState & 0xFFFFFFDF);
                return false;
            }
        }
        if (newState != writeEnteredState) {
            stateUpdater.set(this, newState);
        }
        return true;
    }

    private boolean writeCurrentBuffer() throws IOException {
        long toWrite = 0L;
        for (ByteBuffer b : this.packetHeaderAndDataBuffer) {
            toWrite += (long)b.remaining();
        }
        long r = 0L;
        do {
            if ((r = ((StreamSinkConduit)this.next).write(this.packetHeaderAndDataBuffer, 0, this.packetHeaderAndDataBuffer.length)) == -1L) {
                throw new ClosedChannelException();
            }
            if (r != 0L) continue;
            return false;
        } while ((toWrite -= r) > 0L);
        this.currentDataBuffer.free();
        this.currentDataBuffer = null;
        return true;
    }

    /*
     * Exception decompiling
     */
    public int write(ByteBuffer src) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ByteBuffer[] createHeader(ByteBuffer src) {
        int remaining = src.remaining();
        int chunkSize = remaining + 4;
        byte[] header = new byte[]{65, 66, (byte)(chunkSize >> 8 & 0xFF), (byte)(chunkSize & 0xFF), 3, (byte)(remaining >> 8 & 0xFF), (byte)(remaining & 0xFF)};
        byte[] footer = new byte[]{0};
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.wrap(header), src, ByteBuffer.wrap(footer)};
        return buffers;
    }

    private void exitWrite() {
        stateUpdater.set(this, this.state & 0xFFFFFFDF);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = offset; i < offset + length; ++i) {
            while (srcs[i].hasRemaining()) {
                int written = this.write(srcs[i]);
                if (written <= 0 && total == 0L) {
                    return written;
                }
                if (written <= 0) {
                    return total;
                }
                total += (long)written;
            }
        }
        return total;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        if (!this.processWrite()) {
            return false;
        }
        try {
            int state = this.state;
            if (Bits.allAreSet((int)state, (int)4) && Bits.allAreClear((int)state, (int)8)) {
                ((StreamSinkConduit)this.next).terminateWrites();
                stateUpdater.set(this, state | 8);
            }
            boolean bl = ((StreamSinkConduit)this.next).flush();
            return bl;
        }
        finally {
            this.exitWrite();
        }
    }

    public void suspendWrites() {
        log.trace((Object)"suspend");
        ((StreamSinkConduit)this.next).suspendWrites();
    }

    public void resumeWrites() {
        log.trace((Object)"resume");
        ((StreamSinkConduit)this.next).resumeWrites();
    }

    public boolean isWriteResumed() {
        return ((StreamSinkConduit)this.next).isWriteResumed();
    }

    public void wakeupWrites() {
        log.trace((Object)"wakeup");
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    public void terminateWrites() throws IOException {
        int oldState = 0;
        int newState = 0;
        do {
            if (!Bits.anyAreSet((int)(oldState = this.state), (int)4)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState | 4));
        if (Bits.allAreClear((int)oldState, (int)1) && this.readBodyChunkBuffer == null && this.packetHeaderAndDataBuffer == null) {
            ((StreamSinkConduit)this.next).terminateWrites();
            newState |= 8;
            while (stateUpdater.compareAndSet(this, oldState, newState)) {
                oldState = this.state;
                newState = oldState | 8;
            }
        }
    }

    public void awaitWritable() throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }

    public boolean doGetRequestBodyChunk(ByteBuffer buffer, final AjpRequestConduit requestChannel) throws IOException {
        this.readBodyChunkBuffer = buffer;
        boolean result = this.processWrite();
        if (result) {
            this.exitWrite();
        } else {
            this.exchange.getConnection().getWorker().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (AjpResponseConduit.this.readBodyChunkBuffer != null) {
                            ((StreamSinkConduit)AjpResponseConduit.this.next).awaitWritable();
                            boolean result = AjpResponseConduit.this.processWrite();
                            if (!result) continue;
                            AjpResponseConduit.this.exitWrite();
                        }
                    }
                    catch (IOException e) {
                        if (requestChannel.isReadResumed()) {
                            requestChannel.wakeupReads();
                        }
                        if (AjpResponseConduit.this.isWriteResumed()) {
                            ((StreamSinkConduit)AjpResponseConduit.this.next).wakeupWrites();
                        }
                        UndertowLogger.REQUEST_LOGGER.debug("Error writing get request body chunk");
                    }
                }
            });
        }
        return result;
    }

    static {
        stateUpdater = AtomicIntegerFieldUpdater.newUpdater(AjpResponseConduit.class, "state");
        HashMap<HttpString, Integer> headers = new HashMap<HttpString, Integer>();
        headers.put(Headers.CONTENT_TYPE, 40961);
        headers.put(Headers.CONTENT_LANGUAGE, 40962);
        headers.put(Headers.CONTENT_LENGTH, 40963);
        headers.put(Headers.DATE, 40964);
        headers.put(Headers.LAST_MODIFIED, 40965);
        headers.put(Headers.LOCATION, 40966);
        headers.put(Headers.SET_COOKIE, 40967);
        headers.put(Headers.SET_COOKIE2, 40968);
        headers.put(Headers.SERVLET_ENGINE, 40969);
        headers.put(Headers.STATUS, 40970);
        headers.put(Headers.WWW_AUTHENTICATE, 40971);
        HEADER_MAP = Collections.unmodifiableMap(headers);
    }
}

