/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.AndPredicate;
import io.undertow.predicate.FalsePredicate;
import io.undertow.predicate.MaxContentSizePredicate;
import io.undertow.predicate.MinContentSizePredicate;
import io.undertow.predicate.NotPredicate;
import io.undertow.predicate.OrPredicate;
import io.undertow.predicate.PathMatchPredicate;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PrefixMatchPredicate;
import io.undertow.predicate.SuffixMatchPredicate;
import io.undertow.predicate.TruePredicate;
import io.undertow.server.HttpServerExchange;

public class Predicates {
    public static <T> Predicate<T> and(Predicate<T> ... predicates) {
        return new AndPredicate<T>(predicates);
    }

    public static <T> Predicate<T> or(Predicate<T> ... predicates) {
        return new OrPredicate<T>(predicates);
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new NotPredicate<T>(predicate);
    }

    public static Predicate<HttpServerExchange> path(String path) {
        return new PathMatchPredicate(path);
    }

    public static Predicate<HttpServerExchange> paths(String ... paths) {
        PathMatchPredicate[] predicates = new PathMatchPredicate[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            predicates[i] = new PathMatchPredicate(paths[i]);
        }
        return Predicates.or(predicates);
    }

    public static Predicate<HttpServerExchange> suffix(String path) {
        return new SuffixMatchPredicate(path);
    }

    public static Predicate<HttpServerExchange> suffixs(String ... paths) {
        SuffixMatchPredicate[] predicates = new SuffixMatchPredicate[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            predicates[i] = new SuffixMatchPredicate(paths[i]);
        }
        return Predicates.or(predicates);
    }

    public static Predicate<HttpServerExchange> prefix(String path) {
        return new PrefixMatchPredicate(path);
    }

    public static Predicate<HttpServerExchange> prefixs(String ... paths) {
        PrefixMatchPredicate[] predicates = new PrefixMatchPredicate[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            predicates[i] = new PrefixMatchPredicate(paths[i]);
        }
        return Predicates.or(predicates);
    }

    public static Predicate<HttpServerExchange> maxContentSize(long size) {
        return new MaxContentSizePredicate(size);
    }

    public static Predicate<HttpServerExchange> minContentSize(long size) {
        return new MinContentSizePredicate(size);
    }

    public static <T> Predicate<T> truePredicate() {
        return TruePredicate.instance();
    }

    public static <T> Predicate<T> falsePredicate() {
        return FalsePredicate.instance();
    }

    private Predicates() {
    }
}

