/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public class SingleByteStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final int singleByteReads;
    private int state = 0;

    public SingleByteStreamSourceConduit(StreamSourceConduit next, int singleByteReads) {
        super(next);
        this.singleByteReads = singleByteReads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        if (this.state > this.singleByteReads) {
            return ((StreamSourceConduit)this.next).read(dst);
        }
        if (this.state++ % 2 == 0) {
            return 0;
        }
        if (dst.remaining() == 0) {
            return 0;
        }
        int limit = dst.limit();
        try {
            dst.limit(dst.position() + 1);
            int n = ((StreamSourceConduit)this.next).read(dst);
            return n;
        }
        finally {
            dst.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        if (this.state > this.singleByteReads) {
            return ((StreamSourceConduit)this.next).read(dsts, offs, len);
        }
        if (this.state++ % 2 == 0) {
            return 0L;
        }
        Buffer dst = null;
        for (int i = offs; i < offs + len; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            dst = dsts[i];
            break;
        }
        if (dst == null) {
            return 0L;
        }
        int limit = dst.limit();
        try {
            ((ByteBuffer)dst).limit(dst.position() + 1);
            long l = ((StreamSourceConduit)this.next).read((ByteBuffer)dst);
            return l;
        }
        finally {
            ((ByteBuffer)dst).limit(limit);
        }
    }
}

