/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.UTF8Output;
import io.undertow.websockets.core.WebSockets;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class CloseMessage {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private final int reason;
    private final String string;
    public static final int NORMAL_CLOSURE = 1000;
    public static final int GOING_AWAY = 1001;
    public static final int WRONG_CODE = 1002;
    public static final int PROTOCOL_ERROR = 1003;
    public static final int MSG_CONTAINS_INVALID_DATA = 1007;
    public static final int MSG_VIOLATES_POLICY = 1008;
    public static final int MSG_TOO_BIG = 1009;
    public static final int MISSING_EXTENSIONS = 1010;
    public static final int UNEXPECTED_ERROR = 1011;

    public CloseMessage(ByteBuffer buffer) {
        assert (buffer.remaining() >= 2);
        this.reason = (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
        this.string = new UTF8Output(buffer).extract();
    }

    public CloseMessage(int reason, String string) {
        this.reason = reason;
        this.string = string;
    }

    public CloseMessage(ByteBuffer[] buffers) {
        this(WebSockets.mergeBuffers(buffers));
    }

    public int getReason() {
        return this.reason;
    }

    public String getString() {
        return this.string;
    }

    public ByteBuffer toByteBuffer() {
        byte[] data = this.string.getBytes(utf8);
        ByteBuffer buffer = ByteBuffer.allocate(data.length + 2);
        buffer.putShort((short)this.reason);
        buffer.put(data);
        buffer.flip();
        return buffer;
    }

    public static boolean isValid(int code) {
        return !(code >= 0 && code <= 999 || code >= 1004 && code <= 1006) && (code < 1012 || code > 2999);
    }
}

