/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.ssl;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.server.handlers.file.FileHandlerTestCase;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@AjpIgnore
@RunWith(value=DefaultServer.class)
public class ComplexSSLTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void complexSSLTestCase() throws IOException, GeneralSecurityException, URISyntaxException {
        NameVirtualHostHandler virtualHostHandler;
        PathHandler pathHandler = new PathHandler();
        File rootPath = new File(FileHandlerTestCase.class.getResource("page.html").toURI()).getParentFile();
        NameVirtualHostHandler root = virtualHostHandler = new NameVirtualHostHandler();
        root = new SimpleErrorPageHandler((HttpHandler)root);
        root = new CanonicalPathHandler((HttpHandler)root);
        virtualHostHandler.addHost("default-host", (HttpHandler)pathHandler);
        virtualHostHandler.setDefaultHandler((HttpHandler)pathHandler);
        pathHandler.addPath("/", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(rootPath, 0xA00000L)).setDirectoryListingEnabled(true));
        DefaultServer.setRootHandler((HttpHandler)root);
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet getFileList = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            HttpResponse resultList = client.execute((HttpUriRequest)getFileList);
            Assert.assertEquals((long)200L, (long)resultList.getStatusLine().getStatusCode());
            String responseList = HttpClientUtils.readResponse(resultList);
            Assert.assertTrue((String)responseList, (boolean)responseList.contains("page.html"));
            Header[] headersList = resultList.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headersList[0].getValue());
            HttpGet getFile = new HttpGet(DefaultServer.getDefaultServerSSLAddress() + "/page.html");
            HttpResponse result = client.execute((HttpUriRequest)getFile);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }
}

