/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.handler;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.Methods;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version00.Hybi00Handshake;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.spi.AsyncWebSocketHttpServerExchange;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class WebSocketProtocolHandshakeHandler
implements HttpHandler {
    private final Set<Handshake> handshakes;
    private final WebSocketConnectionCallback callback;
    private final HttpHandler next;

    public WebSocketProtocolHandshakeHandler(WebSocketConnectionCallback callback) {
        this(callback, ResponseCodeHandler.HANDLE_404);
    }

    public WebSocketProtocolHandshakeHandler(WebSocketConnectionCallback callback, HttpHandler next) {
        this.callback = callback;
        HashSet<Handshake> handshakes = new HashSet<Handshake>();
        handshakes.add(new Hybi13Handshake());
        handshakes.add(new Hybi08Handshake());
        handshakes.add(new Hybi07Handshake());
        handshakes.add(new Hybi00Handshake());
        this.handshakes = handshakes;
        this.next = next;
    }

    public WebSocketProtocolHandshakeHandler(Collection<Handshake> handshakes, WebSocketConnectionCallback callback) {
        this(handshakes, callback, ResponseCodeHandler.HANDLE_404);
    }

    public WebSocketProtocolHandshakeHandler(Collection<Handshake> handshakes, WebSocketConnectionCallback callback, HttpHandler next) {
        this.callback = callback;
        this.handshakes = new HashSet<Handshake>(handshakes);
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (!exchange.getRequestMethod().equals(Methods.GET)) {
            exchange.setResponseCode(403);
            exchange.endExchange();
            return;
        }
        AsyncWebSocketHttpServerExchange facade = new AsyncWebSocketHttpServerExchange(exchange);
        Handshake handshaker = null;
        for (Handshake method : this.handshakes) {
            if (!method.matches(facade)) continue;
            handshaker = method;
            break;
        }
        if (handshaker == null) {
            this.next.handleRequest(exchange);
        } else {
            handshaker.handshake(facade, this.callback);
        }
    }
}

