/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.OriginHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class OriginTestCase {
    private static final String HEADER = "selected";
    private static final String MESSAGE = "My HTTP Request!";
    private static BlockingHandler blockingHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrictOrigin() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            OriginHandler handler = new OriginHandler();
            handler.addAllowedOrigins(new String[]{"http://www.mysite.com:80", "http://mysite.com:80"});
            DefaultServer.setRootHandler((HttpHandler)handler);
            handler.setNext((HttpHandler)ResponseCodeHandler.HANDLE_200);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Origin", "http://www.mysite.com:80");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Origin", "http://www.mysite.com:80");
            get.setHeader("Origin", "http://mysite.com:80");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Origin", "http://www.mysite.com:80");
            get.setHeader("Origin", "bogus");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("Origin", "http://www.mysite.com:80");
            get.setHeader("Origin", "bogus");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

