/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.OpenListener;
import io.undertow.server.handlers.RequestDumplingHandler;
import io.undertow.server.handlers.SSLHeaderHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.protocol.ajp.AjpOpenListener;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.util.Headers;
import io.undertow.util.NetworkUtils;
import io.undertow.util.SingleByteStreamSinkConduit;
import io.undertow.util.SingleByteStreamSourceConduit;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.Channel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.JsseXnioSsl;

public class DefaultServer
extends BlockJUnit4ClassRunner {
    private static final String DEFAULT = "default";
    private static final int PROXY_OFFSET = 1111;
    public static final int APACHE_PORT = 9080;
    public static final int APACHE_SSL_PORT = 9443;
    private static boolean first = true;
    private static OptionMap serverOptions;
    private static OpenListener openListener;
    private static ChannelListener acceptListener;
    private static OpenListener proxyOpenListener;
    private static ChannelListener proxyAcceptListener;
    private static XnioWorker worker;
    private static AcceptingChannel<? extends StreamConnection> server;
    private static AcceptingChannel<? extends StreamConnection> proxyServer;
    private static AcceptingChannel<? extends StreamConnection> sslServer;
    private static SSLContext clientSslContext;
    private static Xnio xnio;
    private static final String SERVER_KEY_STORE = "server.keystore";
    private static final String SERVER_TRUST_STORE = "server.truststore";
    private static final String CLIENT_KEY_STORE = "client.keystore";
    private static final String CLIENT_TRUST_STORE = "client.truststore";
    private static final char[] STORE_PASSWORD;
    private static final boolean ajp;
    private static final boolean proxy;
    private static final boolean dump;
    private static final boolean single;
    private static final DelegatingHandler rootHandler;

    private static KeyStore loadKeyStore(String name) throws IOException {
        InputStream stream = DefaultServer.class.getClassLoader().getResourceAsStream(name);
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, STORE_PASSWORD);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (KeyStoreException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        catch (CertificateException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore) throws IOException {
        SSLContext sslContext;
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, STORE_PASSWORD);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        catch (KeyStoreException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialise TrustManager[]", e);
        }
        catch (KeyStoreException e) {
            throw new IOException("Unable to initialise TrustManager[]", e);
        }
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to create and initialise the SSLContext", e);
        }
        catch (KeyManagementException e) {
            throw new IOException("Unable to create and initialise the SSLContext", e);
        }
        return sslContext;
    }

    public static String getDefaultServerURL() {
        return "http://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress(DEFAULT)) + ":" + DefaultServer.getHostPort(DEFAULT);
    }

    public static InetSocketAddress getDefaultServerAddress() {
        return new InetSocketAddress(DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT));
    }

    public static String getDefaultServerSSLAddress() {
        if (sslServer == null && !DefaultServer.isApacheTest()) {
            throw new IllegalStateException("SSL Server not started.");
        }
        return "https://" + DefaultServer.getHostAddress(DEFAULT) + ":" + DefaultServer.getHostSSLPort(DEFAULT);
    }

    public DefaultServer(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static void setupProxyHandlerForSSL(ProxyHandler proxyHandler) {
        proxyHandler.addRequestHeader(Headers.SSL_CLIENT_CERT, "%{SSL_CLIENT_CERT}", DefaultServer.class.getClassLoader());
        proxyHandler.addRequestHeader(Headers.SSL_CIPHER, "%{SSL_CIPHER}", DefaultServer.class.getClassLoader());
        proxyHandler.addRequestHeader(Headers.SSL_SESSION_ID, "%{SSL_SESSION_ID}", DefaultServer.class.getClassLoader());
    }

    public Description getDescription() {
        return super.getDescription();
    }

    public void run(RunNotifier notifier) {
        DefaultServer.runInternal(notifier);
        super.run(notifier);
    }

    private static void runInternal(RunNotifier notifier) {
        if (first) {
            first = false;
            xnio = Xnio.getInstance((String)"nio", (ClassLoader)DefaultServer.class.getClassLoader());
            try {
                worker = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
                serverOptions = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).getMap();
                if (ajp) {
                    openListener = new AjpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 819200), 8192);
                    acceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)openListener));
                    if (!proxy) {
                        int port = 8888;
                        server = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), port), acceptListener, serverOptions);
                    } else {
                        server = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), 8888), acceptListener, serverOptions);
                        proxyOpenListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 819200), OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true), 8192);
                        proxyAcceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)proxyOpenListener));
                        proxyServer = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), proxyAcceptListener, serverOptions);
                        proxyOpenListener.setRootHandler((HttpHandler)new ProxyHandler((ProxyClient)new LoadBalancingProxyClient().addHost(new URI("ajp", null, DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT) + 1111, "/", null, null)), 120000));
                        proxyServer.resumeAccepts();
                    }
                } else {
                    openListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 819200), OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true), 8192);
                    acceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)openListener));
                    if (!proxy) {
                        server = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), acceptListener, serverOptions);
                    } else {
                        InetSocketAddress targetAddress = new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT) + 1111);
                        server = worker.createStreamConnectionServer((SocketAddress)targetAddress, acceptListener, serverOptions);
                        proxyOpenListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 819200), OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true), 8192);
                        proxyAcceptListener = ChannelListeners.openListenerAdapter(DefaultServer.wrapOpenListener((ChannelListener<StreamConnection>)proxyOpenListener));
                        proxyServer = worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), proxyAcceptListener, serverOptions);
                        ProxyHandler proxyHandler = new ProxyHandler((ProxyClient)new LoadBalancingProxyClient().addHost(new URI("http", null, DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT) + 1111, "/", null, null)), 30000);
                        DefaultServer.setupProxyHandlerForSSL(proxyHandler);
                        proxyOpenListener.setRootHandler((HttpHandler)proxyHandler);
                        proxyServer.resumeAccepts();
                    }
                }
                openListener.setRootHandler((HttpHandler)rootHandler);
                server.resumeAccepts();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            notifier.addListener(new RunListener(){

                public void testRunFinished(Result result) throws Exception {
                    server.close();
                    DefaultServer.stopSSLServer();
                    worker.shutdown();
                }
            });
        }
    }

    private static ChannelListener<StreamConnection> wrapOpenListener(final ChannelListener<StreamConnection> listener) {
        if (!single) {
            return listener;
        }
        return new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection channel) {
                channel.getSinkChannel().setConduit((StreamSinkConduit)new SingleByteStreamSinkConduit(channel.getSinkChannel().getConduit(), 10000));
                channel.getSourceChannel().setConduit((StreamSourceConduit)new SingleByteStreamSourceConduit(channel.getSourceChannel().getConduit(), 10000));
                listener.handleEvent((Channel)channel);
            }
        };
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        AjpIgnore ajpIgnore = (AjpIgnore)method.getAnnotation(AjpIgnore.class);
        if (ajpIgnore == null) {
            ajpIgnore = method.getMethod().getDeclaringClass().getAnnotation(AjpIgnore.class);
        }
        if (!(!ajp || ajpIgnore == null || proxy && ajpIgnore.apacheOnly())) {
            return;
        }
        if (proxy && (method.getAnnotation(ProxyIgnore.class) != null || method.getMethod().getDeclaringClass().isAnnotationPresent(ProxyIgnore.class))) {
            return;
        }
        super.runChild(method, notifier);
    }

    public static void setRootHandler(HttpHandler handler) {
        if (proxy && !ajp) {
            handler = new SSLHeaderHandler(handler);
        }
        DefaultServer.rootHandler.next = dump ? new RequestDumplingHandler(handler) : handler;
    }

    public static SSLContext getClientSSLContext() {
        return clientSslContext;
    }

    public static void startSSLServer() throws IOException {
        SSLContext serverContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(SERVER_KEY_STORE), DefaultServer.loadKeyStore(SERVER_TRUST_STORE));
        clientSslContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(CLIENT_KEY_STORE), DefaultServer.loadKeyStore(CLIENT_TRUST_STORE));
        DefaultServer.startSSLServer(serverContext, OptionMap.create((Option)Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED));
    }

    public static void startSSLServer(OptionMap optionMap) throws IOException {
        SSLContext serverContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(SERVER_KEY_STORE), DefaultServer.loadKeyStore(SERVER_TRUST_STORE));
        clientSslContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(CLIENT_KEY_STORE), DefaultServer.loadKeyStore(CLIENT_TRUST_STORE));
        DefaultServer.startSSLServer(serverContext, optionMap);
    }

    public static void startSSLServer(SSLContext context, OptionMap options) throws IOException {
        if (DefaultServer.isApacheTest()) {
            return;
        }
        OptionMap combined = OptionMap.builder().addAll(serverOptions).addAll(options).set(Options.USE_DIRECT_BUFFERS, true).getMap();
        JsseXnioSsl xnioSsl = new JsseXnioSsl(xnio, combined, context);
        sslServer = xnioSsl.createSslConnectionServer(worker, new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostSSLPort(DEFAULT)), proxyAcceptListener != null ? proxyAcceptListener : acceptListener, combined);
        sslServer.resumeAccepts();
    }

    private static boolean isApacheTest() {
        return ajp && !proxy;
    }

    public static void stopSSLServer() throws IOException {
        if (sslServer != null) {
            sslServer.close();
            sslServer = null;
        }
        clientSslContext = null;
    }

    public static String getHostAddress(String serverName) {
        return System.getProperty(serverName + ".server.address", "localhost");
    }

    public static int getHostPort(String serverName) {
        if (DefaultServer.isApacheTest()) {
            return 9080;
        }
        return Integer.getInteger(serverName + ".server.port", 7777);
    }

    public static int getHostSSLPort(String serverName) {
        if (DefaultServer.isApacheTest()) {
            return 9443;
        }
        return Integer.getInteger(serverName + ".server.sslPort", 7778);
    }

    public static OptionMap getUndertowOptions() {
        return openListener.getUndertowOptions();
    }

    public static void setUndertowOptions(OptionMap options) {
        openListener.setUndertowOptions(options);
    }

    public static XnioWorker getWorker() {
        return worker;
    }

    public static boolean isAjp() {
        return ajp;
    }

    public static boolean isProxy() {
        return proxy;
    }

    static {
        STORE_PASSWORD = "password".toCharArray();
        ajp = Boolean.getBoolean("test.ajp");
        proxy = Boolean.getBoolean("test.proxy");
        dump = Boolean.getBoolean("test.dump");
        single = Boolean.getBoolean("test.single");
        rootHandler = new DelegatingHandler();
    }

    private static final class DelegatingHandler
    implements HttpHandler {
        volatile HttpHandler next;

        private DelegatingHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            this.next.handleRequest(exchange);
        }
    }

    public static class Parameterized
    extends org.junit.runners.Parameterized {
        public Parameterized(Class<?> klass) throws Throwable {
            super(klass);
        }

        public void run(RunNotifier notifier) {
            DefaultServer.runInternal(notifier);
            super.run(notifier);
        }
    }
}

