/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.ajp.AjpParseState;
import io.undertow.ajp.AjpParser;
import io.undertow.ajp.AjpRequestConduit;
import io.undertow.ajp.AjpResponseConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.EmptyStreamSourceConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

final class AjpReadListener
implements ChannelListener<StreamSourceChannel>,
ExchangeCompletionListener {
    private static final byte[] CPONG = new byte[]{65, 66, 0, 1, 9};
    private final HttpServerConnection connection;
    private final String scheme;
    private AjpParseState state = new AjpParseState();
    private HttpServerExchange httpServerExchange;
    private volatile int read = 0;
    private final int maxRequestSize;

    AjpReadListener(HttpServerConnection connection, String scheme) {
        this.connection = connection;
        this.scheme = scheme;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 51200);
    }

    public void startRequest() {
        this.connection.resetChannel();
        this.state = new AjpParseState();
        this.httpServerExchange = new HttpServerExchange(this.connection);
        this.httpServerExchange.addExchangeCompleteListener(this);
        this.httpServerExchange.setRequestScheme(this.scheme);
        this.read = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(StreamSourceChannel channel) {
        Pooled existing = this.connection.getExtraBytes();
        Pooled pooled = existing == null ? this.connection.getBufferPool().allocate() : existing;
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        boolean free = true;
        try {
            do {
                int res;
                if (existing == null) {
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                } else {
                    res = buffer.remaining();
                }
                if (res == 0) {
                    if (!channel.isReadResumed()) {
                        channel.getReadSetter().set((ChannelListener)this);
                        channel.resumeReads();
                    }
                    return;
                }
                if (res == -1) {
                    try {
                        channel.shutdownReads();
                        ConduitStreamSinkChannel responseChannel = this.connection.getChannel().getSinkChannel();
                        responseChannel.shutdownWrites();
                        if (!responseChannel.flush()) {
                            responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                            responseChannel.resumeWrites();
                        }
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                    return;
                }
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                int begin = buffer.remaining();
                AjpParser.INSTANCE.parse(buffer, this.state, this.httpServerExchange);
                this.read += begin - buffer.remaining();
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes((Pooled<ByteBuffer>)pooled);
                }
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)((Object)this.connection));
                return;
            } while (!this.state.isComplete());
            if (this.state.prefix != 2) {
                if (this.state.prefix == 10) {
                    UndertowLogger.REQUEST_LOGGER.debug("Received CPING, sending CPONG");
                    this.handleCPing();
                } else if (this.state.prefix == 9) {
                    UndertowLogger.REQUEST_LOGGER.debug("Received CPONG, starting next request");
                    this.state = new AjpParseState();
                    channel.getReadSetter().set((ChannelListener)this);
                    channel.resumeReads();
                } else {
                    UndertowLogger.REQUEST_LOGGER.ignoringAjpRequestWithPrefixCode(this.state.prefix);
                    IoUtils.safeClose((Closeable)((Object)this.connection));
                }
                return;
            }
            channel.getReadSetter().set(null);
            channel.suspendReads();
            final HttpServerExchange httpServerExchange = this.httpServerExchange;
            httpServerExchange.putAttachment(UndertowOptions.ATTACHMENT_KEY, this.connection.getUndertowOptions());
            AjpResponseConduit responseConduit = new AjpResponseConduit(this.connection.getChannel().getSinkChannel().getConduit(), this.connection.getBufferPool(), httpServerExchange, (ConduitListener<? super AjpResponseConduit>)new ConduitListener<AjpResponseConduit>(){

                @Override
                public void handleEvent(AjpResponseConduit channel) {
                    httpServerExchange.terminateResponse();
                }
            });
            this.connection.getChannel().getSinkChannel().setConduit((StreamSinkConduit)responseConduit);
            this.connection.getChannel().getSourceChannel().setConduit(this.createSourceConduit(this.connection.getChannel().getSourceChannel().getConduit(), responseConduit, httpServerExchange));
            try {
                this.state = null;
                this.httpServerExchange = null;
                httpServerExchange.setPersistent(true);
                HttpHandlers.executeRootHandler(this.connection.getRootHandler(), httpServerExchange, Thread.currentThread() instanceof XnioExecutor);
            }
            catch (Throwable t) {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(t);
                IoUtils.safeClose((Closeable)channel);
                IoUtils.safeClose((Closeable)((Object)this.connection));
            }
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
            IoUtils.safeClose((Closeable)this.connection.getChannel());
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    private void handleCPing() {
        this.state = new AjpParseState();
        final StreamConnection underlyingChannel = this.connection.getChannel();
        underlyingChannel.getSourceChannel().suspendReads();
        final ByteBuffer buffer = ByteBuffer.wrap(CPONG);
        try {
            do {
                int res;
                if ((res = underlyingChannel.getSinkChannel().write(buffer)) != 0) continue;
                underlyingChannel.getSinkChannel().setWriteListener((ChannelListener)new ChannelListener<ConduitStreamSinkChannel>(){

                    public void handleEvent(ConduitStreamSinkChannel channel) {
                        do {
                            try {
                                int res = channel.write(buffer);
                                if (res == 0) {
                                    return;
                                }
                            }
                            catch (IOException e) {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                                IoUtils.safeClose((Closeable)((Object)AjpReadListener.this.connection));
                            }
                        } while (buffer.hasRemaining());
                        channel.suspendWrites();
                        AjpReadListener.this.handleEvent((StreamSourceChannel)underlyingChannel.getSourceChannel());
                    }
                });
                underlyingChannel.getSinkChannel().resumeWrites();
                return;
            } while (buffer.hasRemaining());
            this.handleEvent((StreamSourceChannel)underlyingChannel.getSourceChannel());
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)((Object)this.connection));
        }
    }

    @Override
    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
        this.startRequest();
        ConduitStreamSourceChannel channel = exchange.getConnection().getChannel().getSourceChannel();
        channel.getReadSetter().set((ChannelListener)this);
        channel.wakeupReads();
        nextListener.proceed();
    }

    private StreamSourceConduit createSourceConduit(StreamSourceConduit underlyingConduit, AjpResponseConduit responseConduit, final HttpServerExchange exchange) {
        Long length;
        boolean hasTransferEncoding;
        ReadDataStreamSourceConduit conduit = new ReadDataStreamSourceConduit(underlyingConduit, exchange.getConnection());
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        HttpString transferEncoding = Headers.IDENTITY;
        String teHeader = requestHeaders.getLast(Headers.TRANSFER_ENCODING);
        boolean bl = hasTransferEncoding = teHeader != null;
        if (hasTransferEncoding) {
            transferEncoding = new HttpString(teHeader);
        }
        String requestContentLength = requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        if (hasTransferEncoding && !transferEncoding.equals(Headers.IDENTITY)) {
            length = null;
        } else if (requestContentLength != null) {
            long contentLength = Long.parseLong(requestContentLength);
            if (contentLength == 0L) {
                UndertowLogger.REQUEST_LOGGER.trace("No content, starting next request");
                exchange.terminateRequest();
                return new EmptyStreamSourceConduit(conduit.getReadThread());
            }
            length = contentLength;
        } else {
            UndertowLogger.REQUEST_LOGGER.trace("No content length or transfer coding, starting next request");
            exchange.terminateRequest();
            return new EmptyStreamSourceConduit(conduit.getReadThread());
        }
        return new AjpRequestConduit((StreamSourceConduit)conduit, responseConduit, length, (ConduitListener<? super AjpRequestConduit>)new ConduitListener<AjpRequestConduit>(){

            @Override
            public void handleEvent(AjpRequestConduit channel) {
                exchange.terminateRequest();
            }
        });
    }
}

