/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class LoadBalancingProxyTestCase {
    private static final String COUNT = "count";
    private static Undertow server1;
    private static Undertow server2;

    @BeforeClass
    public static void setup() throws URISyntaxException {
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        int port = DefaultServer.getHostPort("default");
        server1 = Undertow.builder().addListener(port + 1, DefaultServer.getHostAddress("default")).setHandler((HttpHandler)Handlers.jvMRoute((String)"JSESSIONID", (String)"s1", (HttpHandler)Handlers.path().addPrefixPath("/session", (HttpHandler)new SessionAttachmentHandler((HttpHandler)new SessionTestHandler(sessionConfig), (SessionManager)new InMemorySessionManager(), (SessionConfig)sessionConfig)).addPrefixPath("/name", (HttpHandler)new StringSendHandler("server1")))).build();
        server2 = Undertow.builder().addListener(port + 2, DefaultServer.getHostAddress("default")).setHandler((HttpHandler)Handlers.jvMRoute((String)"JSESSIONID", (String)"s2", (HttpHandler)Handlers.path().addPrefixPath("/session", (HttpHandler)new SessionAttachmentHandler((HttpHandler)new SessionTestHandler(sessionConfig), (SessionManager)new InMemorySessionManager(), (SessionConfig)sessionConfig)).addPrefixPath("/name", (HttpHandler)new StringSendHandler("server2")))).build();
        server1.start();
        server2.start();
        DefaultServer.setRootHandler((HttpHandler)new ProxyHandler((ProxyClient)new LoadBalancingProxyClient().setConnectionsPerThread(1).addHost(new URI("http", null, DefaultServer.getHostAddress("default"), port + 1, null, null, null), "s1").addHost(new URI("http", null, DefaultServer.getHostAddress("default"), port + 2, null, null, null), "s2"), 10000, (HttpHandler)ResponseCodeHandler.HANDLE_404));
    }

    @AfterClass
    public static void teardown() {
        server1.stop();
        server2.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadShared() throws IOException {
        StringBuilder resultString = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            TestHttpClient client = new TestHttpClient();
            try {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
                HttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                resultString.append(HttpClientUtils.readResponse(result));
                resultString.append(' ');
                continue;
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
        Assert.assertTrue((boolean)resultString.toString().contains("server1"));
        Assert.assertTrue((boolean)resultString.toString().contains("server2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadSharedWithServerShutdown() throws IOException {
        StringBuilder resultString = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            TestHttpClient client = new TestHttpClient();
            try {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
                HttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                resultString.append(HttpClientUtils.readResponse(result));
                resultString.append(' ');
            }
            finally {
                client.getConnectionManager().shutdown();
            }
            server1.stop();
            server1.start();
            server2.stop();
            server2.start();
        }
        Assert.assertTrue((boolean)resultString.toString().contains("server1"));
        Assert.assertTrue((boolean)resultString.toString().contains("server2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickeySessions() throws IOException {
        int expected = 0;
        TestHttpClient client = new TestHttpClient();
        try {
            for (int i = 0; i < 6; ++i) {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/session");
                get.addHeader("Connection", "close");
                HttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                int count = Integer.parseInt(HttpClientUtils.readResponse(result));
                Assert.assertEquals((long)expected++, (long)count);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static final class StringSendHandler
    implements HttpHandler {
        private final String serverName;

        private StringSendHandler(String serverName) {
            this.serverName = serverName;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseSender().send(this.serverName);
        }
    }

    private static final class SessionTestHandler
    implements HttpHandler {
        private final SessionCookieConfig sessionConfig;

        private SessionTestHandler(SessionCookieConfig sessionConfig) {
            this.sessionConfig = sessionConfig;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            SessionManager manager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
            Session session = manager.getSession(exchange, (SessionConfig)this.sessionConfig);
            if (session == null) {
                session = manager.createSession(exchange, (SessionConfig)this.sessionConfig);
                session.setAttribute(LoadBalancingProxyTestCase.COUNT, (Object)0);
            }
            Integer count = (Integer)session.getAttribute(LoadBalancingProxyTestCase.COUNT);
            session.setAttribute(LoadBalancingProxyTestCase.COUNT, (Object)(count + 1));
            exchange.getResponseSender().send("" + count);
        }
    }
}

