/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class BasicAuthenticationTestCase
extends AuthenticationTestBase {
    static AuthenticationMechanism getTestMechanism() {
        return new BasicAuthenticationMechanism("Test Realm");
    }

    @Override
    protected List<AuthenticationMechanism> getTestMechanisms() {
        AuthenticationMechanism mechanism = BasicAuthenticationTestCase.getTestMechanism();
        return Collections.singletonList(mechanism);
    }

    @Test
    public void testBasicSuccess() throws Exception {
        this.setAuthenticationChain();
        BasicAuthenticationTestCase._testBasicSuccess();
        BasicAuthenticationTestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }

    static void _testBasicSuccess() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        String header = BasicAuthenticationTestCase.getAuthHeader(Headers.BASIC, values);
        Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)header);
        HttpClientUtils.readResponse(result);
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"userOne:passwordOne".getBytes(), (boolean)false));
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        HttpClientUtils.readResponse(result);
    }

    @Test
    public void testBadUserName() throws Exception {
        this.setAuthenticationChain();
        BasicAuthenticationTestCase._testBadUserName();
        BasicAuthenticationTestCase.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    static void _testBadUserName() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        String header = BasicAuthenticationTestCase.getAuthHeader(Headers.BASIC, values);
        Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)header);
        HttpClientUtils.readResponse(result);
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"badUser:passwordOne".getBytes(), (boolean)false));
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        HttpClientUtils.readResponse(result);
    }

    @Test
    public void testBadPassword() throws Exception {
        this.setAuthenticationChain();
        BasicAuthenticationTestCase._testBadPassword();
        BasicAuthenticationTestCase.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    static void _testBadPassword() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        String header = BasicAuthenticationTestCase.getAuthHeader(Headers.BASIC, values);
        Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)header);
        HttpClientUtils.readResponse(result);
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"userOne:badPassword".getBytes(), (boolean)false));
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        HttpClientUtils.readResponse(result);
    }
}

