/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.util.AbstractAttachable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.SslChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class HttpServerConnection
extends AbstractAttachable
implements ConnectedChannel {
    private final StreamConnection channel;
    private final CloseSetter closeSetter;
    private final Pool<ByteBuffer> bufferPool;
    private final HttpHandler rootHandler;
    private final OptionMap undertowOptions;
    private final StreamSourceConduit originalSourceConduit;
    private final StreamSinkConduit originalSinkConduit;
    private final List<CloseListener> closeListeners = new LinkedList<CloseListener>();
    private final int bufferSize;
    private Pooled<ByteBuffer> extraBytes;

    public HttpServerConnection(StreamConnection channel, Pool<ByteBuffer> bufferPool, HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        this.channel = channel;
        this.bufferPool = bufferPool;
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.closeSetter = new CloseSetter();
        if (channel != null) {
            this.originalSinkConduit = channel.getSinkChannel().getConduit();
            this.originalSourceConduit = channel.getSourceChannel().getConduit();
            channel.setCloseListener((ChannelListener)this.closeSetter);
        } else {
            this.originalSinkConduit = null;
            this.originalSourceConduit = null;
        }
    }

    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    public StreamConnection getChannel() {
        return this.channel;
    }

    public ChannelListener.Setter<HttpServerConnection> getCloseSetter() {
        return this.closeSetter;
    }

    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    public XnioIoThread getIoThread() {
        if (this.channel == null) {
            return null;
        }
        return this.channel.getIoThread();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.channel.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.channel.setOption(option, value);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)this.channel.getPeerAddress(type);
    }

    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.channel.getLocalAddress(type);
    }

    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public SSLSession getSslSession() {
        if (this.channel instanceof SslChannel) {
            return ((SslChannel)this.channel).getSslSession();
        }
        return null;
    }

    public Pooled<ByteBuffer> getExtraBytes() {
        return this.extraBytes;
    }

    public void setExtraBytes(Pooled<ByteBuffer> extraBytes) {
        this.extraBytes = extraBytes;
    }

    public StreamSourceConduit getOriginalSourceConduit() {
        return this.originalSourceConduit;
    }

    public StreamSinkConduit getOriginalSinkConduit() {
        return this.originalSinkConduit;
    }

    public ConduitState resetChannel() {
        ConduitState ret = new ConduitState(this.channel.getSinkChannel().getConduit(), this.channel.getSourceChannel().getConduit());
        this.channel.getSinkChannel().setConduit(this.originalSinkConduit);
        this.channel.getSourceChannel().setConduit(this.originalSourceConduit);
        return ret;
    }

    public void restoreChannel(ConduitState state) {
        this.channel.getSinkChannel().setConduit(state.sink);
        this.channel.getSourceChannel().setConduit(state.source);
    }

    public void addCloseListener(CloseListener listener) {
        this.closeListeners.add(listener);
    }

    private class CloseSetter
    implements ChannelListener.Setter<HttpServerConnection>,
    ChannelListener<StreamConnection> {
        private ChannelListener<? super HttpServerConnection> listener;

        private CloseSetter() {
        }

        public void set(ChannelListener<? super HttpServerConnection> listener) {
            this.listener = listener;
        }

        public void handleEvent(StreamConnection channel) {
            for (CloseListener l : HttpServerConnection.this.closeListeners) {
                try {
                    l.closed(HttpServerConnection.this);
                }
                catch (Throwable e) {
                    UndertowLogger.REQUEST_LOGGER.exceptionInvokingCloseListener(l, e);
                }
            }
            ChannelListeners.invokeChannelListener((Channel)((Object)HttpServerConnection.this), this.listener);
        }
    }

    public static interface CloseListener {
        public void closed(HttpServerConnection var1);
    }

    public static class ConduitState {
        final StreamSinkConduit sink;
        final StreamSourceConduit source;

        private ConduitState(StreamSinkConduit sink, StreamSourceConduit source) {
            this.sink = sink;
            this.source = source;
        }
    }
}

