/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowMessages;
import io.undertow.util.HeaderMap;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class FormData
implements Iterable<String> {
    private final Map<String, Deque<FormValue>> values = new HashMap<String, Deque<FormValue>>();
    private final int maxValues;
    private int valueCount = 0;

    public FormData(int maxValues) {
        this.maxValues = maxValues;
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.keySet().iterator();
    }

    public FormValue getFirst(String name) {
        Deque<FormValue> deque = this.values.get(name);
        return deque == null ? null : deque.peekFirst();
    }

    public FormValue getLast(String name) {
        Deque<FormValue> deque = this.values.get(name);
        return deque == null ? null : deque.peekLast();
    }

    public Deque<FormValue> get(String name) {
        return this.values.get(name);
    }

    public void add(String name, String value) {
        this.add(name, value, null);
    }

    public void add(String name, String value, HeaderMap headers) {
        Deque<FormValue> values = this.values.get(name);
        if (values == null) {
            values = new ArrayDeque<FormValue>(1);
            this.values.put(name, values);
        }
        values.add(new FormValueImpl(value, headers));
        if (++this.valueCount > this.maxValues) {
            throw UndertowMessages.MESSAGES.tooManyParameters(this.maxValues);
        }
    }

    public void add(String name, File value, String fileName, HeaderMap headers) {
        Deque<FormValue> values = this.values.get(name);
        if (values == null) {
            values = new ArrayDeque<FormValue>(1);
            this.values.put(name, values);
        }
        values.add(new FormValueImpl(value, fileName, headers));
        if (values.size() > this.maxValues) {
            throw UndertowMessages.MESSAGES.tooManyParameters(this.maxValues);
        }
        if (++this.valueCount > this.maxValues) {
            throw UndertowMessages.MESSAGES.tooManyParameters(this.maxValues);
        }
    }

    public void put(String name, String value, HeaderMap headers) {
        ArrayDeque<FormValueImpl> values = new ArrayDeque<FormValueImpl>(1);
        Deque old = this.values.put(name, values);
        if (old != null) {
            this.valueCount -= old.size();
        }
        values.add(new FormValueImpl(value, headers));
        if (++this.valueCount > this.maxValues) {
            throw UndertowMessages.MESSAGES.tooManyParameters(this.maxValues);
        }
    }

    public Deque<FormValue> remove(String name) {
        Deque<FormValue> old = this.values.remove(name);
        if (old != null) {
            this.valueCount -= old.size();
        }
        return old;
    }

    public boolean contains(String name) {
        Deque<FormValue> value = this.values.get(name);
        return value != null && !value.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormData strings = (FormData)o;
        return !(this.values != null ? !this.values.equals(strings.values) : strings.values != null);
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }

    public String toString() {
        return "FormData{values=" + this.values + '}';
    }

    static class FormValueImpl
    implements FormValue {
        private final String value;
        private final String fileName;
        private final File file;
        private final HeaderMap headers;

        FormValueImpl(String value, HeaderMap headers) {
            this.value = value;
            this.headers = headers;
            this.file = null;
            this.fileName = null;
        }

        FormValueImpl(File file, String fileName, HeaderMap headers) {
            this.file = file;
            this.headers = headers;
            this.fileName = fileName;
            this.value = null;
        }

        @Override
        public String getValue() {
            if (this.value == null) {
                throw UndertowMessages.MESSAGES.formValueIsAFile();
            }
            return this.value;
        }

        @Override
        public boolean isFile() {
            return this.file != null;
        }

        @Override
        public File getFile() {
            if (this.file == null) {
                throw UndertowMessages.MESSAGES.formValueIsAString();
            }
            return this.file;
        }

        @Override
        public HeaderMap getHeaders() {
            return this.headers;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }

    public static interface FormValue {
        public String getValue();

        public boolean isFile();

        public File getFile();

        public String getFileName();

        public HeaderMap getHeaders();
    }
}

