/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

public class URLDecodingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final String charset;

    public URLDecodingHandler(HttpHandler next, String charset) {
        this.next = next;
        this.charset = charset;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.setRequestPath(URLDecoder.decode(exchange.getRequestPath(), this.charset));
        exchange.setRelativePath(URLDecoder.decode(exchange.getRelativePath(), this.charset));
        exchange.setResolvedPath(URLDecoder.decode(exchange.getResolvedPath(), this.charset));
        if (!exchange.getQueryString().isEmpty()) {
            for (Map.Entry<String, Deque<String>> param : exchange.getQueryParameters().entrySet()) {
                ArrayDeque<String> newVales = new ArrayDeque<String>(param.getValue().size());
                for (String val : param.getValue()) {
                    newVales.add(URLDecoder.decode(val, this.charset));
                }
                param.setValue(newVales);
            }
        }
    }
}

