/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.NotificationReceiverHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.FormAuthenticationMechanism;
import io.undertow.security.impl.InMemorySingleSignOnManager;
import io.undertow.security.impl.SingleSignOnAuthenticationMechanism;
import io.undertow.security.impl.SingleSignOnManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SsoTestCase
extends AuthenticationTestBase {
    @BeforeClass
    public static void setup() {
        SingleSignOnAuthenticationMechanism sso = new SingleSignOnAuthenticationMechanism((SingleSignOnManager)new InMemorySingleSignOnManager());
        PathHandler path = new PathHandler();
        AuthenticationTestBase.ResponseHandler current = new AuthenticationTestBase.ResponseHandler();
        current = new AuthenticationCallHandler((HttpHandler)current);
        current = new AuthenticationConstraintHandler((HttpHandler)current);
        ArrayList<Object> mechs = new ArrayList<Object>();
        mechs.add(sso);
        mechs.add(new BasicAuthenticationMechanism("Test Realm"));
        current = new AuthenticationMechanismsHandler((HttpHandler)current, mechs);
        current = new NotificationReceiverHandler((HttpHandler)current, Collections.singleton(auditReceiver));
        current = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, identityManager, (HttpHandler)current);
        path.addPrefixPath("/test1", (HttpHandler)current);
        current = new AuthenticationTestBase.ResponseHandler();
        current = new AuthenticationCallHandler((HttpHandler)current);
        current = new AuthenticationConstraintHandler((HttpHandler)current);
        mechs = new ArrayList();
        mechs.add(sso);
        mechs.add(new FormAuthenticationMechanism("form", "/login", "/error"));
        current = new AuthenticationMechanismsHandler((HttpHandler)current, mechs);
        current = new NotificationReceiverHandler((HttpHandler)current, Collections.singleton(auditReceiver));
        current = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, identityManager, (HttpHandler)current);
        path.addPrefixPath("/test2", (HttpHandler)current);
        DefaultServer.setRootHandler((HttpHandler)new SessionAttachmentHandler((HttpHandler)path, (SessionManager)new InMemorySessionManager(""), (SessionConfig)new SessionCookieConfig()));
    }

    @Override
    protected List<AuthenticationMechanism> getTestMechanisms() {
        return null;
    }

    @Test
    public void testSsoSuccess() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/test1");
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        String header = SsoTestCase.getAuthHeader(Headers.BASIC, values);
        Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)header);
        HttpClientUtils.readResponse(result);
        get = new HttpGet(DefaultServer.getDefaultServerURL() + "/test1");
        get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"userOne:passwordOne".getBytes(), (boolean)false));
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        HttpClientUtils.readResponse(result);
        SsoTestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
        get = new HttpGet(DefaultServer.getDefaultServerURL() + "/test2");
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        HttpClientUtils.readResponse(result);
        SsoTestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }
}

