/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.util.SecureHashMap;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class SecureHashMapTestCase {
    @Test
    public void testGetNonExistentDoesNotNPE() {
        SecureHashMap map = new SecureHashMap();
        map.get((Object)"nothing");
    }

    @Test
    public void testLotsOfPutsAndGets() {
        SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
        HashMap<String, String> reference = new HashMap<String, String>();
        SecureHashMap map = new SecureHashMap();
        for (int i = 0; i < 10000; ++i) {
            String key = generator.createSessionId();
            String value = generator.createSessionId();
            map.put((Object)key, (Object)value);
            reference.put(key, value);
        }
        for (Map.Entry entry : reference.entrySet()) {
            Assert.assertEquals(entry.getValue(), (Object)map.get(entry.getKey()));
            Assert.assertEquals(entry.getValue(), (Object)map.remove(entry.getKey()));
        }
        Assert.assertEquals((long)0L, (long)map.size());
    }
}

