/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.HttpString;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public final class HeaderValues
extends AbstractCollection<String>
implements Deque<String>,
List<String>,
RandomAccess {
    private static final String[] NO_STRINGS = new String[0];
    final HttpString key;
    byte head;
    byte size;
    Object value;

    HeaderValues(HttpString key) {
        this.key = key;
    }

    public HttpString getHeaderName() {
        return this.key;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        byte size = this.size;
        if (size == 0) {
            return;
        }
        this.clearInternal(size);
    }

    private void clearInternal(byte size) {
        byte head = this.head;
        Object value = this.value;
        if (value instanceof String[]) {
            int tail = head + size;
            Object[] strings = (String[])value;
            int len = strings.length;
            if (tail > len) {
                Arrays.fill(strings, (int)head, len, null);
                Arrays.fill(strings, 0, tail - len, null);
            } else {
                Arrays.fill(strings, (int)head, tail, null);
            }
        } else {
            this.value = null;
        }
        this.size = 0;
        this.head = 0;
    }

    private int index(int idx) {
        assert (idx >= 0);
        assert (idx < this.size);
        int len = ((String[])this.value).length;
        if ((idx += this.head) > len) {
            idx -= len;
        }
        return idx;
    }

    @Override
    public ListIterator<String> listIterator() {
        return this.iterator(0, true);
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        return this.iterator(index, true);
    }

    @Override
    public Iterator<String> iterator() {
        return this.iterator(0, true);
    }

    @Override
    public Iterator<String> descendingIterator() {
        return this.iterator(0, false);
    }

    private ListIterator<String> iterator(final int start, final boolean forwards) {
        return new ListIterator<String>(){
            int idx;
            int returned;
            {
                this.idx = start;
                this.returned = -1;
            }

            @Override
            public boolean hasNext() {
                return this.idx < HeaderValues.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.idx > 0;
            }

            @Override
            public String next() {
                try {
                    if (forwards) {
                        int idx = this.idx;
                        String next = HeaderValues.this.get(idx);
                        this.returned = idx;
                        this.idx = idx + 1;
                        return next;
                    }
                    int idx = this.idx - 1;
                    String next = HeaderValues.this.get(idx);
                    this.idx = this.returned = idx;
                    return next;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int nextIndex() {
                return this.idx;
            }

            @Override
            public String previous() {
                try {
                    if (!forwards) {
                        int idx = this.idx;
                        String prev = HeaderValues.this.get(idx);
                        this.returned = idx;
                        this.idx = idx + 1;
                        return prev;
                    }
                    int idx = this.idx - 1;
                    String prev = HeaderValues.this.get(idx);
                    this.idx = this.returned = idx;
                    return prev;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int previousIndex() {
                return this.idx - 1;
            }

            @Override
            public void remove() {
                if (this.returned == -1) {
                    throw new IllegalStateException();
                }
                HeaderValues.this.remove(this.returned);
                this.returned = -1;
            }

            @Override
            public void set(String headerValue) {
                if (this.returned == -1) {
                    throw new IllegalStateException();
                }
                HeaderValues.this.set(this.returned, headerValue);
            }

            @Override
            public void add(String headerValue) {
                if (this.returned == -1) {
                    throw new IllegalStateException();
                }
                int idx = this.idx;
                HeaderValues.this.add(idx, headerValue);
                this.idx = idx + 1;
                this.returned = -1;
            }
        };
    }

    @Override
    public boolean offerFirst(String headerValue) {
        byte size = this.size;
        if (headerValue == null || size == 127) {
            return false;
        }
        Object value = this.value;
        if (value instanceof String[]) {
            String[] strings = (String[])value;
            int len = strings.length;
            byte head = this.head;
            if (size == len) {
                String[] newStrings = Arrays.copyOfRange(strings, (int)head, head + len + (len << 1));
                int end = head + size;
                if (end > len) {
                    System.arraycopy(strings, 0, newStrings, len - head, end - len);
                }
                this.head = (byte)(head - 1);
                newStrings[this.head] = headerValue;
                this.value = newStrings;
            } else if (head == 0) {
                this.head = (byte)(len - 1);
                strings[this.head] = headerValue;
            } else {
                this.head = (byte)(head - 1);
                strings[this.head] = headerValue;
            }
            this.size = (byte)(size + 1);
        } else {
            if (size == 0) {
                this.value = headerValue;
                this.size = 1;
            } else {
                this.value = new String[]{headerValue, (String)value, null, null};
                this.size = (byte)2;
            }
            this.head = 0;
        }
        return true;
    }

    @Override
    public boolean offerLast(String headerValue) {
        byte size = this.size;
        if (headerValue == null || size == 127) {
            return false;
        }
        Object value = this.value;
        if (value instanceof String[]) {
            this.offerLastMultiValue(headerValue, size, (String[])value);
        } else {
            if (size == 0) {
                this.value = headerValue;
                this.size = 1;
            } else {
                this.value = new String[]{(String)value, headerValue, null, null};
                this.size = (byte)2;
            }
            this.head = 0;
        }
        return true;
    }

    private void offerLastMultiValue(String headerValue, int size, String[] value) {
        String[] strings = value;
        int len = strings.length;
        byte head = this.head;
        int end = head + size;
        if (size == len) {
            String[] newStrings = Arrays.copyOfRange(strings, (int)head, head + len + (len << 1));
            if (end > len) {
                System.arraycopy(strings, 0, newStrings, len - head, end - len);
            }
            newStrings[len] = headerValue;
            this.value = newStrings;
        } else if (end >= len) {
            strings[end - len] = headerValue;
        } else {
            strings[end] = headerValue;
        }
        this.size = (byte)(size + 1);
    }

    private boolean offer(int idx, String headerValue) {
        byte size = this.size;
        if (idx < 0 || idx > size || size == 127 || headerValue == null) {
            return false;
        }
        if (idx == 0) {
            return this.offerFirst(headerValue);
        }
        if (idx == size) {
            return this.offerLast(headerValue);
        }
        assert (size >= 2);
        Object value = this.value;
        assert (value instanceof String[]);
        String[] strings = (String[])value;
        int len = strings.length;
        byte head = this.head;
        int end = head + size;
        int headIdx = head + idx;
        if (size == len) {
            int newLen = (len << 1) + len;
            String[] newStrings = new String[newLen];
            if (head == 0) {
                assert (headIdx == len);
                assert (end == len);
                System.arraycopy(value, 0, newStrings, 0, idx);
                System.arraycopy(value, idx, newStrings, idx + 1, len - idx);
            } else if (headIdx < len) {
                System.arraycopy(value, head, newStrings, 0, idx);
                System.arraycopy(value, headIdx, newStrings, idx + 1, len - headIdx);
                System.arraycopy(value, 0, newStrings, len - head + 1, head);
            } else if (headIdx > len) {
                System.arraycopy(value, 0, newStrings, len - head, headIdx - len);
                System.arraycopy(value, headIdx - len, newStrings, idx + 1, len - idx + 1);
                System.arraycopy(value, head, newStrings, 0, len - head);
            }
            newStrings[idx] = headerValue;
            this.value = newStrings;
            this.head = 0;
        } else if (end > len) {
            if (headIdx < len) {
                System.arraycopy(value, head, value, head - 1, idx);
                strings[headIdx - 1] = headerValue;
                this.head = (byte)(head - 1);
            } else if (headIdx > len) {
                System.arraycopy(value, headIdx - len, value, headIdx - len + 1, size - idx);
                strings[headIdx - len] = headerValue;
            } else {
                assert (headIdx == len);
                System.arraycopy(value, 0, value, 1, end - len);
                strings[0] = headerValue;
            }
            strings[idx] = headerValue;
        } else {
            assert (size < len && end <= len);
            if (head == 0 || idx >= size >> 1) {
                assert (end < len);
                System.arraycopy(value, headIdx, value, headIdx + 1, size - idx);
                strings[headIdx] = headerValue;
            } else {
                assert (end <= len || idx < size << 1);
                assert (head > 0);
                System.arraycopy(value, headIdx, value, headIdx - 1, size - idx);
                strings[headIdx - 1] = headerValue;
                this.head = (byte)(head - 1);
            }
        }
        this.size = (byte)(size + 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pollFirst() {
        byte size = this.size;
        if (size == 0) {
            return null;
        }
        Object value = this.value;
        if (value instanceof String) {
            this.size = 0;
            this.value = null;
            return (String)value;
        }
        String[] strings = (String[])value;
        int n = this.head;
        this.head = (byte)(n + 1);
        int idx = n;
        this.size = (byte)(size - 1);
        int len = strings.length;
        if (idx > len) {
            idx -= len;
        }
        try {
            String string = strings[idx];
            return string;
        }
        finally {
            strings[idx] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pollLast() {
        byte size = this.size;
        if (size == 0) {
            return null;
        }
        Object value = this.value;
        if (value instanceof String) {
            this.size = 0;
            this.value = null;
            return (String)value;
        }
        this.size = (byte)(size - 1);
        int idx = this.head + this.size;
        String[] strings = (String[])value;
        int len = strings.length;
        if (idx > len) {
            idx -= len;
        }
        try {
            String string = strings[idx];
            return string;
        }
        finally {
            strings[idx] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String remove(int idx) {
        byte size = this.size;
        if (idx < 0 || idx >= size) {
            throw new IndexOutOfBoundsException();
        }
        if (idx == 0) {
            return this.removeFirst();
        }
        if (idx == size - 1) {
            return this.removeLast();
        }
        assert (size > 2);
        String[] value = (String[])this.value;
        int len = value.length;
        byte head = this.head;
        int headIdx = idx + head;
        int end = head + size;
        if (end > len) {
            if (headIdx > len) {
                try {
                    String string = value[headIdx - len];
                    return string;
                }
                finally {
                    System.arraycopy(value, headIdx + 1 - len, value, headIdx - len, size - idx - 1);
                    this.size = (byte)(size - 1);
                }
            }
            try {
                String string = value[headIdx];
                return string;
            }
            finally {
                System.arraycopy(value, head, value, head + 1, idx);
                this.size = (byte)(size - 1);
            }
        }
        try {
            String string = value[headIdx];
            return string;
        }
        finally {
            System.arraycopy(value, headIdx + 1, value, headIdx, size - idx - 1);
            this.size = (byte)(size - 1);
        }
    }

    @Override
    public String get(int idx) {
        if (idx > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object value = this.value;
        assert (value != null);
        if (value instanceof String) {
            assert (this.size == 1);
            return (String)value;
        }
        String[] a = (String[])value;
        return a[this.index(idx)];
    }

    @Override
    public int indexOf(Object o) {
        if (o == null || this.size == 0) {
            return -1;
        }
        if (this.value instanceof String[]) {
            String[] list = (String[])this.value;
            int len = list.length;
            for (int i = 0; i < this.size; ++i) {
                int idx = i + this.head;
                if (!(idx > len ? list[idx - len] : list[idx]).equals(o)) continue;
                return i;
            }
        } else if (o.equals(this.value)) {
            return 0;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null || this.size == 0) {
            return -1;
        }
        if (this.value instanceof String[]) {
            String[] list = (String[])this.value;
            int len = list.length;
            for (int i = this.size - 1; i >= 0; --i) {
                int idx = i + this.head;
                if (!(idx > len ? list[idx - len] : list[idx]).equals(o)) continue;
                return i;
            }
        } else if (o.equals(this.value)) {
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(int index, String element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        byte size = this.size;
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException();
        }
        Object value = this.value;
        if (size == 1 && value instanceof String) {
            try {
                String string = (String)value;
                return string;
            }
            finally {
                this.value = element;
            }
        }
        String[] list = (String[])value;
        int i = this.index(index);
        try {
            String string = list[i];
            return string;
        }
        finally {
            list[i] = element;
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        byte size = this.size;
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        Iterator<? extends String> iterator = c.iterator();
        boolean result = false;
        while (iterator.hasNext()) {
            result |= this.offer(index, iterator.next());
        }
        return result;
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        int len = toIndex - fromIndex;
        String[] strings = new String[len];
        for (int i = 0; i < len; ++i) {
            strings[i] = this.get(i + fromIndex);
        }
        return Arrays.asList(strings);
    }

    public String[] toArray() {
        byte size = this.size;
        if (size == 0) {
            return NO_STRINGS;
        }
        Object v = this.value;
        if (v instanceof String) {
            return new String[]{(String)v};
        }
        byte head = this.head;
        int copyEnd = head + size;
        String[] list = (String[])v;
        int len = list.length;
        if (copyEnd < len) {
            return Arrays.copyOfRange(list, (int)head, copyEnd);
        }
        String[] ret = Arrays.copyOfRange(list, (int)head, copyEnd);
        System.arraycopy(list, 0, ret, len - head, copyEnd - len);
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        byte size = this.size;
        if (size == 0) {
            return a;
        }
        int inLen = a.length;
        T[] target = inLen < size ? Arrays.copyOfRange(a, inLen, inLen + size) : a;
        Object v = this.value;
        if (v instanceof String) {
            target[0] = v;
        } else {
            byte head = this.head;
            int copyEnd = head + size;
            String[] list = (String[])v;
            int len = list.length;
            if (copyEnd < len) {
                System.arraycopy(list, head, target, 0, size);
            } else {
                int wrapEnd = len - head;
                System.arraycopy(list, head, target, 0, wrapEnd);
                System.arraycopy(list, 0, target, wrapEnd, copyEnd - len);
            }
        }
        return target;
    }

    @Override
    public void addFirst(String s) {
        if (s == null) {
            return;
        }
        if (!this.offerFirst(s)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void addLast(String s) {
        if (s == null) {
            return;
        }
        if (!this.offerLast(s)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void add(int index, String s) {
        if (s == null) {
            return;
        }
        if (!this.offer(index, s)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public String peekFirst() {
        return this.size == 0 ? null : this.get(0);
    }

    @Override
    public String peekLast() {
        return this.size == 0 ? null : this.get(this.size - 1);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        int i = this.indexOf(o);
        return i != -1 && this.remove(i) != null;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        int i = this.lastIndexOf(o);
        return i != -1 && this.remove(i) != null;
    }

    @Override
    public boolean add(String s) {
        this.addLast(s);
        return true;
    }

    @Override
    public void push(String s) {
        this.addFirst(s);
    }

    @Override
    public String pop() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(String s) {
        return this.offerLast(s);
    }

    @Override
    public String poll() {
        return this.pollFirst();
    }

    @Override
    public String peek() {
        return this.peekFirst();
    }

    @Override
    public String remove() {
        return this.removeFirst();
    }

    @Override
    public String removeFirst() {
        String s = this.pollFirst();
        if (s == null) {
            throw new NoSuchElementException();
        }
        return s;
    }

    @Override
    public String removeLast() {
        String s = this.pollLast();
        if (s == null) {
            throw new NoSuchElementException();
        }
        return s;
    }

    @Override
    public String getFirst() {
        String s = this.peekFirst();
        if (s == null) {
            throw new NoSuchElementException();
        }
        return s;
    }

    @Override
    public String getLast() {
        String s = this.peekLast();
        if (s == null) {
            throw new NoSuchElementException();
        }
        return s;
    }

    @Override
    public String element() {
        return this.getFirst();
    }

    @Override
    public boolean remove(Object obj) {
        return this.removeFirstOccurrence(obj);
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        return this.addAll(0, c);
    }
}

