/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.UTF8Output;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.Pooled;

public class BufferedTextMessage {
    private final UTF8Output data = new UTF8Output();
    private final boolean bufferFullMessage;
    private final long maxMessageSize;
    private boolean complete;
    long currentSize;

    public BufferedTextMessage(long maxMessageSize, boolean bufferFullMessage) {
        this.maxMessageSize = maxMessageSize;
        this.bufferFullMessage = bufferFullMessage;
    }

    public BufferedTextMessage(boolean bufferFullMessage) {
        this(-1L, bufferFullMessage);
    }

    private void checkMaxSize(StreamSourceFrameChannel channel, int res) throws IOException {
        if (res > 0) {
            this.currentSize += (long)res;
        }
        if (this.maxMessageSize > 0L && this.currentSize > this.maxMessageSize) {
            WebSockets.sendClose(new CloseMessage(1009, WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize)).toByteBuffer(), channel.getWebSocketChannel(), null);
            throw new IOException(WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize));
        }
    }

    public void readBlocking(StreamSourceFrameChannel channel) throws IOException {
        Pooled pooled = channel.getWebSocketChannel().getBufferPool().allocate();
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        try {
            while (true) {
                int res;
                if ((res = channel.read(buffer)) == -1) {
                    buffer.flip();
                    this.data.write(buffer);
                    this.complete = true;
                    return;
                }
                if (res == 0) {
                    channel.awaitReadable();
                }
                this.checkMaxSize(channel, res);
                if (buffer.hasRemaining()) continue;
                buffer.flip();
                this.data.write(buffer);
                buffer.compact();
                if (this.bufferFullMessage) continue;
                return;
            }
        }
        finally {
            pooled.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(StreamSourceFrameChannel channel, final WebSocketCallback<BufferedTextMessage> callback) {
        Pooled pooled = channel.getWebSocketChannel().getBufferPool().allocate();
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        try {
            while (true) {
                int res;
                if ((res = channel.read(buffer)) == -1) {
                    this.complete = true;
                    buffer.flip();
                    this.data.write(buffer);
                    callback.complete(channel.getWebSocketChannel(), this);
                    return;
                }
                if (res == 0) {
                    buffer.flip();
                    if (buffer.hasRemaining()) {
                        this.data.write(buffer);
                        if (!this.bufferFullMessage) {
                            callback.complete(channel.getWebSocketChannel(), this);
                        }
                    }
                    channel.getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceFrameChannel>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void handleEvent(StreamSourceFrameChannel channel) {
                            Pooled pooled = channel.getWebSocketChannel().getBufferPool().allocate();
                            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                            try {
                                while (true) {
                                    int res;
                                    if ((res = channel.read(buffer)) == -1) {
                                        BufferedTextMessage.this.checkMaxSize(channel, res);
                                        buffer.flip();
                                        BufferedTextMessage.this.data.write(buffer);
                                        BufferedTextMessage.this.complete = true;
                                        callback.complete(channel.getWebSocketChannel(), BufferedTextMessage.this);
                                        return;
                                    }
                                    if (res == 0) {
                                        buffer.flip();
                                        if (!buffer.hasRemaining()) return;
                                        BufferedTextMessage.this.data.write(buffer);
                                        if (BufferedTextMessage.this.bufferFullMessage) return;
                                        callback.complete(channel.getWebSocketChannel(), BufferedTextMessage.this);
                                        return;
                                    }
                                    if (buffer.hasRemaining()) continue;
                                    buffer.flip();
                                    BufferedTextMessage.this.data.write(buffer);
                                    buffer.clear();
                                    if (BufferedTextMessage.this.bufferFullMessage) continue;
                                    callback.complete(channel.getWebSocketChannel(), BufferedTextMessage.this);
                                    continue;
                                    break;
                                }
                            }
                            catch (IOException e) {
                                callback.onError(channel.getWebSocketChannel(), BufferedTextMessage.this, e);
                                return;
                            }
                            finally {
                                pooled.free();
                            }
                        }
                    });
                    channel.resumeReads();
                    return;
                }
                this.checkMaxSize(channel, res);
                if (buffer.hasRemaining()) continue;
                buffer.flip();
                this.data.write(buffer);
                buffer.clear();
                if (this.bufferFullMessage) continue;
                callback.complete(channel.getWebSocketChannel(), this);
                continue;
                break;
            }
        }
        catch (IOException e) {
            callback.onError(channel.getWebSocketChannel(), this, e);
            return;
        }
        finally {
            pooled.free();
        }
    }

    public String getData() {
        return this.data.extract();
    }

    public boolean isComplete() {
        return this.complete;
    }
}

