/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogFileTestCase;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class AccessLogTestCase {
    private static volatile String message;
    private volatile CountDownLatch latch;
    private final AccessLogReceiver RECEIVER = new AccessLogReceiver(){

        public void logMessage(String msg) {
            message = msg;
            AccessLogTestCase.this.latch.countDown();
        }
    };
    private static final HttpHandler HELLO_HANDLER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteAddress() throws IOException, InterruptedException {
        this.latch = new CountDownLatch(1);
        DefaultServer.setRootHandler((HttpHandler)new AccessLogHandler(HELLO_HANDLER, this.RECEIVER, "Remote address %a Code %s test-header %{i,test-header}", AccessLogFileTestCase.class.getClassLoader()));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("test-header", "test-value");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            this.latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)"Remote address 127.0.0.1 Code 200 test-header test-value", (Object)message);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    static {
        HELLO_HANDLER = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("Hello");
            }
        };
    }
}

