/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;

@AjpIgnore
@ProxyIgnore
@RunWith(value=DefaultServer.class)
public class MaxRequestSizeTestCase {
    public static final String A_MESSAGE = "A message";

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                try {
                    OutputStream outputStream = exchange.getOutputStream();
                    InputStream inputStream = exchange.getInputStream();
                    String m = HttpClientUtils.readResponse(inputStream);
                    Assert.assertEquals((Object)MaxRequestSizeTestCase.A_MESSAGE, (Object)m);
                    inputStream.close();
                    outputStream.close();
                }
                catch (IOException e) {
                    try {
                        exchange.getResponseHeaders().put(Headers.CONNECTION, "close");
                        exchange.setResponseCode(500);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxRequestHeaderSize() throws IOException {
        OptionMap existing = DefaultServer.getUndertowOptions();
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            post.setEntity((HttpEntity)new StringEntity(A_MESSAGE));
            post.addHeader("Connection", "close");
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            OptionMap maxSize = OptionMap.create((Option)UndertowOptions.MAX_HEADER_SIZE, (Object)10);
            DefaultServer.setUndertowOptions(maxSize);
            try {
                HttpResponse response = client.execute((HttpUriRequest)post);
                HttpClientUtils.readResponse(response);
                if (DefaultServer.isProxy() || DefaultServer.isAjp()) {
                    Assert.assertEquals((long)500L, (long)response.getStatusLine().getStatusCode());
                } else {
                    Assert.fail((String)"request should have been too big");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            maxSize = OptionMap.create((Option)UndertowOptions.MAX_HEADER_SIZE, (Object)1000);
            DefaultServer.setUndertowOptions(maxSize);
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
        }
        finally {
            DefaultServer.setUndertowOptions(existing);
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxRequestEntitySize() throws IOException {
        OptionMap existing = DefaultServer.getUndertowOptions();
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            post.setEntity((HttpEntity)new StringEntity(A_MESSAGE));
            post.addHeader("Connection", "close");
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            OptionMap maxSize = OptionMap.create((Option)UndertowOptions.MAX_ENTITY_SIZE, (Object)((long)A_MESSAGE.length() - 1L));
            DefaultServer.setUndertowOptions(maxSize);
            post = new HttpPost(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            post.setEntity((HttpEntity)new StringEntity(A_MESSAGE));
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)500L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            maxSize = OptionMap.create((Option)UndertowOptions.MAX_HEADER_SIZE, (Object)1000);
            DefaultServer.setUndertowOptions(maxSize);
            post = new HttpPost(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            post.setEntity((HttpEntity)new StringEntity(A_MESSAGE));
            post.addHeader("Connection", "close");
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
        }
        finally {
            DefaultServer.setUndertowOptions(existing);
            client.getConnectionManager().shutdown();
        }
    }
}

