/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.framed;

import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class AbstractFramedStreamSourceChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements StreamSourceChannel {
    private final ChannelListener.SimpleSetter<? extends R> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<? extends R> closeSetter = new ChannelListener.SimpleSetter();
    private final StreamSourceChannel underlying;
    private final AbstractFramedChannel<C, R, S> framedChannel;
    private final Deque<FrameData> pendingFrameData = new LinkedList<FrameData>();
    private int state = 0;
    private static final int STATE_DONE = 2;
    private static final int STATE_READS_RESUMED = 4;
    private static final int STATE_CLOSED = 8;
    private static final int STATE_LAST_FRAME = 16;
    private static final int STATE_IN_LISTENER_LOOP = 32;
    private Pooled<ByteBuffer> data;
    private long frameDataRemaining;
    private final Object lock = new Object();
    private int waiters;
    private volatile boolean waitingForFrame;
    private int readFrameCount = 0;

    public AbstractFramedStreamSourceChannel(AbstractFramedChannel<C, R, S> framedChannel) {
        this.underlying = framedChannel.getSourceChannel();
        this.framedChannel = framedChannel;
        this.waitingForFrame = true;
    }

    public AbstractFramedStreamSourceChannel(AbstractFramedChannel<C, R, S> framedChannel, Pooled<ByteBuffer> data, long frameDataRemaining) {
        this.underlying = framedChannel.getSourceChannel();
        this.framedChannel = framedChannel;
        this.waitingForFrame = data == null && frameDataRemaining <= 0L;
        this.data = data;
        this.frameDataRemaining = frameDataRemaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return -1L;
        }
        this.beforeRead();
        if (this.waitingForFrame) {
            return 0L;
        }
        try {
            if (this.frameDataRemaining == 0L && Bits.anyAreSet((int)this.state, (int)16)) {
                long l = -1L;
                return l;
            }
            if (this.data != null) {
                int old = ((ByteBuffer)this.data.getResource()).limit();
                try {
                    if (count < (long)((ByteBuffer)this.data.getResource()).remaining()) {
                        ((ByteBuffer)this.data.getResource()).limit((int)((long)((ByteBuffer)this.data.getResource()).position() + count));
                    }
                    int written = target.write((ByteBuffer)this.data.getResource(), position);
                    this.frameDataRemaining -= (long)written;
                    long l = written;
                    return l;
                }
                finally {
                    ((ByteBuffer)this.data.getResource()).limit(old);
                }
            }
            if (this.frameDataRemaining > 0L) {
                long toTransfer = count;
                if (toTransfer > this.frameDataRemaining) {
                    toTransfer = this.frameDataRemaining;
                }
                long written = this.underlying.transferTo(position, toTransfer, target);
                this.frameDataRemaining -= written;
                long l = written;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.exitRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel streamSinkChannel) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return -1L;
        }
        this.beforeRead();
        if (this.waitingForFrame) {
            return 0L;
        }
        try {
            if (this.frameDataRemaining == 0L && Bits.anyAreSet((int)this.state, (int)16)) {
                long l = -1L;
                return l;
            }
            if (this.data != null) {
                int old = ((ByteBuffer)this.data.getResource()).limit();
                try {
                    if (count < (long)((ByteBuffer)this.data.getResource()).remaining()) {
                        ((ByteBuffer)this.data.getResource()).limit((int)((long)((ByteBuffer)this.data.getResource()).position() + count));
                    }
                    int written = streamSinkChannel.write((ByteBuffer)this.data.getResource());
                    this.frameDataRemaining -= (long)written;
                    long l = written;
                    return l;
                }
                finally {
                    ((ByteBuffer)this.data.getResource()).limit(old);
                }
            }
            if (this.frameDataRemaining > 0L) {
                long toTransfer = count;
                if (toTransfer > this.frameDataRemaining) {
                    toTransfer = this.frameDataRemaining;
                }
                long written = this.underlying.transferTo(toTransfer, throughBuffer, streamSinkChannel);
                this.frameDataRemaining -= written;
                long l = written;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.exitRead();
        }
    }

    public void suspendReads() {
        this.state &= 0xFFFFFFFB;
    }

    protected void complete() throws IOException {
    }

    protected boolean isComplete() {
        return Bits.anyAreSet((int)this.state, (int)2);
    }

    public void resumeReads() {
        this.resumeReads(false);
    }

    public boolean isReadResumed() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public void wakeupReads() {
        this.resumeReads(true);
    }

    void resumeReads(boolean wakeup) {
        this.state |= 4;
        if (this.data == null && this.frameDataRemaining > 0L) {
            if (wakeup) {
                this.underlying.wakeupReads();
            } else {
                this.underlying.resumeReads();
            }
        } else if (!Bits.anyAreSet((int)this.state, (int)32)) {
            this.getIoThread().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AbstractFramedStreamSourceChannel.this.state |= 32;
                    try {
                        do {
                            ChannelListener listener;
                            if ((listener = AbstractFramedStreamSourceChannel.this.getReadListener()) == null || !AbstractFramedStreamSourceChannel.this.isReadResumed()) {
                                return;
                            }
                            ChannelListeners.invokeChannelListener((Channel)((Object)AbstractFramedStreamSourceChannel.this), (ChannelListener)listener);
                        } while (Bits.allAreClear((int)AbstractFramedStreamSourceChannel.this.state, (int)8) && AbstractFramedStreamSourceChannel.this.frameDataRemaining > 0L);
                    }
                    finally {
                        AbstractFramedStreamSourceChannel.this.state &= -33;
                    }
                }
            });
        }
    }

    private ChannelListener<? super R> getReadListener() {
        return this.readSetter.get();
    }

    public void shutdownReads() throws IOException {
        this.close();
    }

    protected void lastFrame() {
        this.state |= 0x10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable() throws IOException {
        if (this.data == null) {
            if (this.frameDataRemaining > 0L) {
                this.underlying.awaitReadable();
            } else {
                Object object = this.lock;
                synchronized (object) {
                    if (this.data == null) {
                        try {
                            ++this.waiters;
                            this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                        finally {
                            --this.waiters;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable(long l, TimeUnit timeUnit) throws IOException {
        if (this.data == null) {
            if (this.frameDataRemaining > 0L) {
                this.underlying.awaitReadable(l, timeUnit);
            } else {
                Object object = this.lock;
                synchronized (object) {
                    if (this.data == null) {
                        try {
                            ++this.waiters;
                            this.lock.wait(timeUnit.toMillis(l));
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                        finally {
                            --this.waiters;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dataReady(FrameHeaderData headerData, Pooled<ByteBuffer> frameData) {
        Object object = this.lock;
        synchronized (object) {
            if (this.frameDataRemaining == 0L && this.pendingFrameData.isEmpty()) {
                this.data = frameData;
                this.frameDataRemaining = headerData.getFrameLength();
                if (this.waiters > 0) {
                    this.lock.notifyAll();
                }
                this.handleHeaderData(headerData);
                if (Bits.anyAreSet((int)this.state, (int)4)) {
                    this.resumeReads(false);
                }
                this.waitingForFrame = false;
            } else {
                this.pendingFrameData.add(new FrameData(headerData, frameData));
            }
        }
    }

    protected void handleHeaderData(FrameHeaderData headerData) {
    }

    public XnioExecutor getReadThread() {
        return this.underlying.getIoThread();
    }

    public ChannelListener.Setter<? extends R> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<? extends R> getCloseSetter() {
        return this.closeSetter;
    }

    public XnioWorker getWorker() {
        return this.underlying.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.underlying.getIoThread();
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> tOption) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> tOption, T t) throws IllegalArgumentException, IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        int i;
        long t;
        long toTransfer;
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return -1L;
        }
        this.beforeRead();
        if (this.waitingForFrame) {
            return 0L;
        }
        try {
            if (this.frameDataRemaining == 0L && Bits.anyAreSet((int)this.state, (int)16)) {
                long l = -1L;
                return l;
            }
            if (this.data != null) {
                int old = ((ByteBuffer)this.data.getResource()).limit();
                try {
                    long count = Buffers.remaining((Buffer[])dsts, (int)offset, (int)length);
                    if (count < (long)((ByteBuffer)this.data.getResource()).remaining()) {
                        ((ByteBuffer)this.data.getResource()).limit((int)((long)((ByteBuffer)this.data.getResource()).position() + count));
                    } else {
                        count = ((ByteBuffer)this.data.getResource()).remaining();
                    }
                    int written = Buffers.copy((int)((int)count), (ByteBuffer[])dsts, (int)offset, (int)length, (ByteBuffer)((ByteBuffer)this.data.getResource()));
                    this.frameDataRemaining -= (long)written;
                    long l = written;
                    return l;
                }
                finally {
                    ((ByteBuffer)this.data.getResource()).limit(old);
                }
            }
            if (this.frameDataRemaining > 0L) {
                toTransfer = Buffers.remaining((Buffer[])dsts, (int)offset, (int)length);
                if (toTransfer > this.frameDataRemaining) {
                    toTransfer = this.frameDataRemaining;
                }
            } else {
                long l = 0L;
                return l;
            }
            t = 0L;
            i = 0;
        }
        finally {
            this.exitRead();
        }
        while (true) {
            if (i >= length) {
                long read = this.underlying.read(dsts, offset, length);
                this.frameDataRemaining -= read;
                return read;
            }
            ByteBuffer buffer = dsts[i + offset];
            int lim = buffer.limit();
            if ((t += (long)(lim - buffer.position())) > toTransfer) {
                buffer.limit(lim - (int)(t - toTransfer));
                try {
                    long read = this.underlying.read(dsts, offset, i + 1);
                    this.frameDataRemaining -= read;
                    long l = read;
                    return l;
                }
                finally {
                    buffer.limit(lim);
                }
            }
            ++i;
        }
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        block19: {
            if (Bits.anyAreSet((int)this.state, (int)2)) {
                return -1;
            }
            this.beforeRead();
            if (this.waitingForFrame) {
                return 0;
            }
            if (this.frameDataRemaining == 0L && Bits.anyAreSet((int)this.state, (int)16)) {
                int n = -1;
                return n;
            }
            if (this.data != null) {
                int old = ((ByteBuffer)this.data.getResource()).limit();
                try {
                    int count = dst.remaining();
                    if (count < ((ByteBuffer)this.data.getResource()).remaining()) {
                        ((ByteBuffer)this.data.getResource()).limit(((ByteBuffer)this.data.getResource()).position() + count);
                    } else {
                        count = ((ByteBuffer)this.data.getResource()).remaining();
                    }
                    int written = Buffers.copy((int)count, (ByteBuffer)dst, (ByteBuffer)((ByteBuffer)this.data.getResource()));
                    this.frameDataRemaining -= (long)written;
                    int n = written;
                    return n;
                }
                finally {
                    ((ByteBuffer)this.data.getResource()).limit(old);
                }
            }
            if (this.frameDataRemaining <= 0L) break block19;
            int old = dst.limit();
            try {
                if ((long)dst.remaining() > this.frameDataRemaining) {
                    dst.limit((int)((long)dst.position() + this.frameDataRemaining));
                }
                int written = this.underlying.read(dst);
                this.frameDataRemaining -= (long)written;
                int n = written;
                return n;
            }
            finally {
                dst.limit(old);
            }
        }
        int n = 0;
        return n;
        finally {
            this.exitRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeRead() {
        if (this.frameDataRemaining == 0L) {
            Object object = this.lock;
            synchronized (object) {
                FrameData pending = this.pendingFrameData.poll();
                if (pending != null) {
                    this.data = pending.getFrameData();
                    this.frameDataRemaining = pending.getFrameHeaderData().getFrameLength();
                    this.handleHeaderData(pending.getFrameHeaderData());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitRead() throws IOException {
        if (this.data != null && !((ByteBuffer)this.data.getResource()).hasRemaining()) {
            this.data.free();
            this.data = null;
        }
        if (this.frameDataRemaining == 0L) {
            Object object = this.lock;
            synchronized (object) {
                ++this.readFrameCount;
                if (this.pendingFrameData.isEmpty()) {
                    try {
                        if (Bits.anyAreSet((int)this.state, (int)16)) {
                            this.state |= 2;
                            this.complete();
                        } else {
                            this.waitingForFrame = true;
                        }
                    }
                    finally {
                        this.framedChannel.notifyFrameReadComplete(this);
                    }
                }
            }
        }
    }

    public boolean isOpen() {
        return Bits.allAreClear((int)this.state, (int)8);
    }

    public void close() throws IOException {
        this.state |= 8;
        if (Bits.allAreClear((int)this.state, (int)2)) {
            this.framedChannel.markReadsBroken(null);
        }
    }

    protected AbstractFramedChannel<C, R, S> getFramedChannel() {
        return this.framedChannel;
    }

    protected int getReadFrameCount() {
        return this.readFrameCount;
    }

    private class FrameData {
        private final FrameHeaderData frameHeaderData;
        private final Pooled<ByteBuffer> frameData;

        FrameData(FrameHeaderData frameHeaderData, Pooled<ByteBuffer> frameData) {
            this.frameHeaderData = frameHeaderData;
            this.frameData = frameData;
        }

        FrameHeaderData getFrameHeaderData() {
            return this.frameHeaderData;
        }

        Pooled<ByteBuffer> getFrameData() {
            return this.frameData;
        }
    }
}

