/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.Options;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.WriteTimeoutException;

@RunWith(value=DefaultServer.class)
@AjpIgnore
@Ignore(value="This test fails intermittently")
public class WriteTimeoutTestCase {
    private volatile Exception exception;
    private static final CountDownLatch errorLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteTimeout() throws IOException, InterruptedException {
        block9: {
            DefaultServer.setRootHandler(new HttpHandler(){

                public void handleRequest(final HttpServerExchange exchange) throws Exception {
                    final StreamSinkChannel response = exchange.getResponseChannel();
                    try {
                        response.setOption(Options.WRITE_TIMEOUT, (Object)10);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    int capacity = 0x100000;
                    final ByteBuffer originalBuffer = ByteBuffer.allocateDirect(0x100000);
                    for (int i = 0; i < 0x100000; ++i) {
                        originalBuffer.put((byte)42);
                    }
                    originalBuffer.flip();
                    response.getWriteSetter().set((ChannelListener)new ChannelListener<Channel>(){
                        private ByteBuffer buffer;
                        int count;
                        {
                            this.buffer = originalBuffer.duplicate();
                            this.count = 0;
                        }

                        public void handleEvent(Channel channel) {
                            do {
                                try {
                                    int res = response.write(this.buffer);
                                    if (res == 0) {
                                        return;
                                    }
                                }
                                catch (IOException e) {
                                    WriteTimeoutTestCase.this.exception = e;
                                    errorLatch.countDown();
                                }
                                if (this.buffer.hasRemaining()) continue;
                                ++this.count;
                                this.buffer = originalBuffer.duplicate();
                            } while (this.count < 1000);
                            exchange.endExchange();
                        }
                    });
                    response.wakeupWrites();
                }
            });
            TestHttpClient client = new TestHttpClient();
            try {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
                HttpResponse result = client.execute((HttpUriRequest)get);
                InputStream content = result.getEntity().getContent();
                byte[] buffer = new byte[512];
                int r = 0;
                while ((r = content.read(buffer)) > 0) {
                    Thread.sleep(200L);
                    if (this.exception == null) continue;
                    Assert.assertEquals(WriteTimeoutException.class, this.exception.getClass());
                    return;
                }
                try {
                    Assert.fail((String)"Write did not time out");
                }
                catch (IOException e) {
                    if (errorLatch.await(5L, TimeUnit.SECONDS)) {
                        Assert.assertEquals(WriteTimeoutException.class, this.exception.getClass());
                        break block9;
                    }
                    Assert.fail((String)"Write did not time out");
                }
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
    }
}

