/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.MetricsHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.CompletionLatchHandler;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class MetricsHandlerTestCase {
    private static MetricsHandler metricsHandler;
    private static CompletionLatchHandler latchHandler;

    @BeforeClass
    public static void setup() {
        metricsHandler = new MetricsHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                Thread.sleep(100L);
                exchange.getResponseSender().send("Hello");
            }
        });
        latchHandler = new CompletionLatchHandler((HttpHandler)metricsHandler);
        DefaultServer.setRootHandler(latchHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetrics() throws IOException, InterruptedException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        try {
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            latchHandler.await();
            latchHandler.reset();
            MetricsHandler.MetricResult metrics = metricsHandler.getMetrics();
            Assert.assertEquals((long)1L, (long)metrics.getTotalRequests());
            Assert.assertTrue((metrics.getMaxRequestTime() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)metrics.getMinRequestTime(), (long)metrics.getMaxRequestTime());
            Assert.assertEquals((long)metrics.getMaxRequestTime(), (long)metrics.getTotalRequestTime());
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            latchHandler.await();
            latchHandler.reset();
            metrics = metricsHandler.getMetrics();
            Assert.assertEquals((long)2L, (long)metrics.getTotalRequests());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

