/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2014 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package io.undertow.spdy;

import org.xnio.Pool;

import java.nio.ByteBuffer;
import java.util.zip.Inflater;

/**
 * Parser for SPDY headers frames.
 *
 * @author Stuart Douglas
 */
class SpdyHeadersParser extends SpdyHeaderBlockParser {

    public SpdyHeadersParser(Pool<ByteBuffer> bufferPool, SpdyChannel channel, int frameLength, Inflater inflater) {
        super(bufferPool, channel,frameLength, inflater);
    }

    @Override
    protected boolean handleBeforeHeader(ByteBuffer resource) {
        if (resource.remaining() < 4) {
            return false;
        }
        streamId = SpdyProtocolUtils.readInt(resource);
        return true;
    }
}
