/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.ajp;

import io.undertow.client.ajp.AjpConstants;
import io.undertow.client.ajp.AjpResponseBuilder;
import io.undertow.client.ajp.AjpResponseParseState;
import io.undertow.server.protocol.ajp.AbstractAjpParser;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;

class AjpResponseParser
extends AbstractAjpParser {
    public static final AjpResponseParser INSTANCE = new AjpResponseParser();
    public static final int SEND_HEADERS = 4;
    public static final int CPONG = 9;
    public static final int CPING = 10;
    public static final int SHUTDOWN = 7;
    private static final int AB = 16706;

    AjpResponseParser() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(ByteBuffer buf, AjpResponseParseState state, AjpResponseBuilder builder) {
        if (!buf.hasRemaining()) {
            return;
        }
        switch (state.state) {
            case 0: {
                AbstractAjpParser.IntegerHolder result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    return;
                }
                if (result.value != 16706) {
                    throw new IllegalStateException("Wrong magic number");
                }
            }
            case 2: {
                AbstractAjpParser.IntegerHolder result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    state.state = 2;
                    return;
                }
                state.dataSize = result.value;
            }
            case 3: {
                byte prefix;
                if (!buf.hasRemaining()) {
                    state.state = 3;
                    return;
                }
                state.prefix = prefix = buf.get();
                if (prefix != 4 && prefix != 6) {
                    state.state = 15;
                    return;
                }
            }
            case 4: {
                Object result = this.parse16BitInteger(buf, state);
                if (!((AbstractAjpParser.IntegerHolder)result).readComplete) {
                    state.state = 4;
                    return;
                }
                if (state.prefix != 4) {
                    state.state = 15;
                    state.currentIntegerPart = ((AbstractAjpParser.IntegerHolder)result).value;
                    return;
                }
                builder.setStatusCode(((AbstractAjpParser.IntegerHolder)result).value);
            }
            case 5: {
                Object result = this.parseString(buf, state, false);
                if (!((AbstractAjpParser.StringHolder)result).readComplete) {
                    state.state = 5;
                    return;
                }
                builder.setReasonPhrase(((AbstractAjpParser.StringHolder)result).value);
            }
            case 6: {
                Object result = this.parse16BitInteger(buf, state);
                if (!((AbstractAjpParser.IntegerHolder)result).readComplete) {
                    state.state = 6;
                    return;
                }
                state.numHeaders = ((AbstractAjpParser.IntegerHolder)result).value;
            }
            case 7: {
                for (int readHeaders = state.readHeaders; readHeaders < state.numHeaders; ++readHeaders) {
                    AbstractAjpParser.StringHolder result;
                    if (state.currentHeader == null) {
                        result = this.parseString(buf, state, true);
                        if (!result.readComplete) {
                            state.state = 7;
                            state.readHeaders = readHeaders;
                            return;
                        }
                        state.currentHeader = result.header != null ? result.header : HttpString.tryFromString(result.value);
                    }
                    result = this.parseString(buf, state, false);
                    if (!result.readComplete) {
                        state.state = 7;
                        state.readHeaders = readHeaders;
                        return;
                    }
                    builder.getResponseHeaders().add(state.currentHeader, result.value);
                    state.currentHeader = null;
                }
                break;
            }
        }
        state.state = 15;
    }

    @Override
    protected HttpString headers(int offset) {
        return AjpConstants.HTTP_HEADERS_ARRAY[offset];
    }
}

