/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.net.InetSocketAddress;

public class ProxyPeerAddressHandler
implements HttpHandler {
    private final HttpHandler next;

    public ProxyPeerAddressHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String forwardedProto;
        String forwardedFor = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_FOR);
        if (forwardedFor != null) {
            int index = forwardedFor.indexOf(44);
            String value = index == -1 ? forwardedFor : forwardedFor.substring(0, index);
            exchange.setSourceAddress(InetSocketAddress.createUnresolved(value, 0));
        }
        if ((forwardedProto = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PROTO)) != null) {
            exchange.setRequestScheme(forwardedProto);
        }
        String forwardedHost = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_HOST);
        String forwardedPort = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PORT);
        if (forwardedHost != null) {
            int index = forwardedHost.indexOf(44);
            String value = index == -1 ? forwardedHost : forwardedHost.substring(0, index);
            int port = 0;
            if (forwardedPort != null) {
                port = Integer.parseInt(forwardedPort);
            }
            exchange.setDestinationAddress(InetSocketAddress.createUnresolved(value, port));
        }
        this.next.handleRequest(exchange);
    }
}

