/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.client.UndertowClient;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPAdvertiseTask;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.xnio.ssl.XnioSsl;

public class ModCluster {
    private static final HttpHandler NEXT_HANDLER = ResponseCodeHandler.HANDLE_404;
    private final long healtCheckInterval;
    private final long removeBrokenNodes;
    private final ModClusterContainer container;
    private final HttpHandler proxyHandler;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private final String serverID = UUID.randomUUID().toString();

    ModCluster(Builder builder) {
        this.healtCheckInterval = builder.healthCheckInterval;
        this.removeBrokenNodes = builder.removeBrokenNodes;
        this.container = new ModClusterContainer(this, builder.xnioSsl, builder.client);
        this.proxyHandler = new ProxyHandler(this.container.getProxyClient(), builder.maxRequestTime, NEXT_HANDLER);
    }

    protected String getServerID() {
        return this.serverID;
    }

    protected ModClusterContainer getContainer() {
        return this.container;
    }

    long getHealtCheckInterval() {
        return this.healtCheckInterval;
    }

    long getRemoveBrokenNodes() {
        return this.removeBrokenNodes;
    }

    public HttpHandler getProxyHandler() {
        return this.proxyHandler;
    }

    public synchronized void start() {
        if (this.healtCheckInterval > 0L) {
            this.executorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ModCluster.this.container.checkHealth();
                }
            }, this.healtCheckInterval, this.healtCheckInterval, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void advertise(MCMPConfig config) {
        MCMPConfig.AdvertiseConfig advertiseConfig = config.getAdvertiseConfig();
        if (advertiseConfig == null) {
            throw new IllegalArgumentException("advertise not enabled");
        }
        int frequency = advertiseConfig.getAdvertiseFrequency();
        MCMPAdvertiseTask task = new MCMPAdvertiseTask(this.container, advertiseConfig);
        this.executorService.scheduleAtFixedRate(task, 1000L, frequency, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        this.executorService.shutdownNow();
    }

    public static Builder builder() {
        return ModCluster.builder(UndertowClient.getInstance(), null);
    }

    public static Builder builder(UndertowClient client) {
        return ModCluster.builder(client, null);
    }

    public static Builder builder(UndertowClient client, XnioSsl xnioSsl) {
        return new Builder(client, xnioSsl);
    }

    public static class Builder {
        private final XnioSsl xnioSsl;
        private final UndertowClient client;
        private int maxRequestTime = -1;
        private long healthCheckInterval = TimeUnit.SECONDS.toMillis(10L);
        private long removeBrokenNodes = TimeUnit.MINUTES.toMillis(1L);

        private Builder(UndertowClient client, XnioSsl xnioSsl) {
            this.xnioSsl = xnioSsl;
            this.client = client;
        }

        public ModCluster build() {
            return new ModCluster(this);
        }

        public Builder setMaxRequestTime(int maxRequestTime) {
            this.maxRequestTime = maxRequestTime;
            return this;
        }

        public Builder setHealthCheckInterval(long healthCheckInterval) {
            this.healthCheckInterval = healthCheckInterval;
            return this;
        }

        public Builder setRemoveBrokenNodes(long removeBrokenNodes) {
            this.removeBrokenNodes = removeBrokenNodes;
            return this;
        }
    }
}

