/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.XnioSsl;

class NodePingUtil {
    private static final ClientRequest PING_REQUEST;

    NodePingUtil() {
    }

    static void pingHost(InetSocketAddress address, HttpServerExchange exchange, PingCallback callback, OptionMap options) {
        XnioIoThread thread = exchange.getIoThread();
        XnioWorker worker = thread.getWorker();
        HostPingTask r = new HostPingTask(address, worker, callback, options);
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : thread, r);
    }

    static void pingHttpClient(URI connection, PingCallback callback, HttpServerExchange exchange, UndertowClient client, XnioSsl xnioSsl, OptionMap options) {
        XnioIoThread thread = exchange.getIoThread();
        HttpClientPingTask r = new HttpClientPingTask(connection, callback, thread, client, xnioSsl, exchange.getConnection().getBufferPool(), options);
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : thread, r);
    }

    static void pingNode(final Node node, final HttpServerExchange exchange, final PingCallback callback) {
        if (node == null) {
            callback.failed();
            return;
        }
        final int timeout = node.getNodeConfig().getTimeout();
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : exchange.getIoThread(), new Runnable(){

            @Override
            public void run() {
                node.getConnectionPool().connect(null, exchange, new ProxyCallback<ProxyConnection>(){

                    @Override
                    public void completed(HttpServerExchange exchange, ProxyConnection result) {
                        exchange.dispatch(SameThreadExecutor.INSTANCE, new ConnectionPoolPingTask(result, callback));
                    }

                    @Override
                    public void failed(HttpServerExchange exchange) {
                        callback.failed();
                    }
                }, timeout, TimeUnit.SECONDS, false);
            }
        });
    }

    static {
        ClientRequest request = new ClientRequest();
        request.setMethod(Methods.OPTIONS);
        request.setPath("*");
        request.getRequestHeaders().add(Headers.USER_AGENT, "mod_cluster ping");
        PING_REQUEST = request;
    }

    static class RequestExchangeListener
    implements ClientCallback<ClientExchange> {
        private final PingCallback callback;
        private final ClientExchange exchange;
        private final boolean closeConnection;

        RequestExchangeListener(PingCallback callback, ClientExchange exchange, boolean closeConnection) {
            this.callback = callback;
            this.exchange = exchange;
            this.closeConnection = closeConnection;
        }

        @Override
        public void completed(final ClientExchange result) {
            ChannelListener listener = ChannelListeners.drainListener((long)Long.MAX_VALUE, (ChannelListener)new ChannelListener<StreamSourceChannel>(){

                public void handleEvent(StreamSourceChannel channel) {
                    int responseCode = result.getResponse().getResponseCode();
                    RequestExchangeListener.this.callback.completed();
                    if (RequestExchangeListener.this.closeConnection) {
                        IoUtils.safeClose((Closeable)RequestExchangeListener.this.exchange.getConnection());
                    }
                }
            }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSourceChannel>(){

                public void handleException(StreamSourceChannel channel, IOException exception) {
                    RequestExchangeListener.this.callback.failed();
                    IoUtils.safeClose((Closeable)RequestExchangeListener.this.exchange.getConnection());
                }
            });
            listener.handleEvent((Channel)result.getResponseChannel());
        }

        @Override
        public void failed(IOException e) {
            this.callback.failed();
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
        }
    }

    static class HttpClientPingTask
    implements Runnable {
        private URI connection;
        private PingCallback callback;
        private XnioIoThread thread;
        private UndertowClient client;
        private XnioSsl xnioSsl;
        private Pool<ByteBuffer> bufferPool;
        private OptionMap options;

        HttpClientPingTask(URI connection, PingCallback callback, XnioIoThread thread, UndertowClient client, XnioSsl xnioSsl, Pool<ByteBuffer> bufferPool, OptionMap options) {
            this.connection = connection;
            this.callback = callback;
            this.thread = thread;
            this.client = client;
            this.xnioSsl = xnioSsl;
            this.bufferPool = bufferPool;
            this.options = options;
        }

        @Override
        public void run() {
            this.client.connect(new ClientCallback<ClientConnection>(){

                @Override
                public void completed(final ClientConnection result) {
                    result.sendRequest(PING_REQUEST, new ClientCallback<ClientExchange>(){

                        @Override
                        public void completed(ClientExchange result2) {
                            RequestExchangeListener listener = new RequestExchangeListener(HttpClientPingTask.this.callback, result2, true);
                            result2.setResponseListener(listener);
                        }

                        @Override
                        public void failed(IOException e) {
                            HttpClientPingTask.this.callback.failed();
                            IoUtils.safeClose((Closeable)result);
                        }
                    });
                }

                @Override
                public void failed(IOException e) {
                    HttpClientPingTask.this.callback.failed();
                }
            }, this.connection, this.thread, this.xnioSsl, this.bufferPool, this.options);
        }
    }

    static class HostPingTask
    implements Runnable {
        private final InetSocketAddress address;
        private final PingCallback callback;
        private final XnioWorker worker;
        private final OptionMap options;

        HostPingTask(InetSocketAddress address, XnioWorker worker, PingCallback callback, OptionMap options) {
            this.address = address;
            this.worker = worker;
            this.callback = callback;
            this.options = options;
        }

        @Override
        public void run() {
            try {
                IoFuture future = this.worker.openStreamConnection((SocketAddress)this.address, (ChannelListener)new ChannelListener<StreamConnection>(){

                    public void handleEvent(StreamConnection channel) {
                        IoUtils.safeClose((Closeable)channel);
                    }
                }, this.options);
                future.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<StreamConnection, Void>(){

                    public void handleCancelled(Void attachment) {
                        HostPingTask.this.callback.failed();
                    }

                    public void handleFailed(IOException exception, Void attachment) {
                        HostPingTask.this.callback.failed();
                    }

                    public void handleDone(StreamConnection data, Void attachment) {
                        HostPingTask.this.callback.completed();
                    }
                }, null);
            }
            catch (Exception e) {
                this.callback.failed();
            }
        }
    }

    static class ConnectionPoolPingTask
    implements Runnable {
        private final PingCallback callback;
        private final ProxyConnection proxyConnection;

        ConnectionPoolPingTask(ProxyConnection proxyConnection, PingCallback callback) {
            this.proxyConnection = proxyConnection;
            this.callback = callback;
        }

        @Override
        public void run() {
            this.proxyConnection.getConnection().sendRequest(PING_REQUEST, new ClientCallback<ClientExchange>(){

                @Override
                public void completed(final ClientExchange result) {
                    result.setResponseListener(new ClientCallback<ClientExchange>(){

                        @Override
                        public void completed(ClientExchange result2) {
                            RequestExchangeListener listener = new RequestExchangeListener(ConnectionPoolPingTask.this.callback, result2, false);
                            result2.setResponseListener(listener);
                        }

                        @Override
                        public void failed(IOException e) {
                            ConnectionPoolPingTask.this.callback.failed();
                            IoUtils.safeClose((Closeable)result.getConnection());
                        }
                    });
                }

                @Override
                public void failed(IOException e) {
                    ConnectionPoolPingTask.this.callback.failed();
                }
            });
        }
    }

    static interface PingCallback {
        public void completed();

        public void failed();
    }
}

